/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class SubscriptionDialog
extends CenteredDialog {
    private VectorTableModel tableModel = new VectorTableModel();
    private Vector rows = new Vector();
    private JTable table;
    private TableSorter sorter;
    private boolean okSelected = false;

    public SubscriptionDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.setTitle("Select Channels");
        this.initializeTable();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = this.createButtonPanel();
        jPanel.add((Component)jPanel2, "South");
        this.setContentPane(jPanel);
        this.pack();
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("     "), gridBagConstraints);
        JButton jButton = new JButton("   OK   ");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(new okAction());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JLabel("     "), gridBagConstraints);
        JButton jButton2 = new JButton(" Cancel ");
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jButton2, gridBagConstraints);
        jButton2.addActionListener(new cancelAction());
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("     "), gridBagConstraints);
        return jPanel;
    }

    private void initializeTable() {
        Serializable serializable;
        SubscriptionTableRow subscriptionTableRow = new SubscriptionTableRow("STN01.BHZ", false);
        this.tableModel.setPrototype(subscriptionTableRow);
        this.sorter = new TableSorter(this.tableModel);
        this.table = new JTable(this.sorter);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(false);
        this.table.getTableHeader().setResizingAllowed(false);
        int n = this.table.getColumnCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            serializable = this.table.getColumnModel().getColumn(n3);
            int n4 = subscriptionTableRow.getPreferredWidth(n3);
            n2 += n4;
            ((TableColumn)serializable).setMinWidth(n4);
            ((TableColumn)serializable).setMaxWidth(n4 * 2);
            ++n3;
        }
        serializable = new Dimension(n2 * 3 / 2, 200);
        this.table.setPreferredScrollableViewportSize((Dimension)serializable);
    }

    public void setChannels(StringSet stringSet, StringSet stringSet2) {
        this.rows.clear();
        int n = 0;
        while (n < stringSet.size()) {
            String string = stringSet.get(n);
            boolean bl = stringSet2.contains(string);
            this.rows.add(new SubscriptionTableRow(string, bl));
            ++n;
        }
        this.tableModel.setRows(this.rows);
    }

    public StringSet getSelectedChannels() {
        StringSet stringSet = new StringSet();
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            SubscriptionTableRow subscriptionTableRow = (SubscriptionTableRow)enumeration.nextElement();
            if (!subscriptionTableRow.isSelected()) continue;
            stringSet.add(subscriptionTableRow.getName());
        }
        return stringSet;
    }

    public boolean isOkSelected() {
        return this.okSelected;
    }

    class cancelAction
    implements ActionListener {
        cancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SubscriptionDialog.this.okSelected = false;
            SubscriptionDialog.this.closeWindow();
        }
    }

    class okAction
    implements ActionListener {
        okAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SubscriptionDialog.this.okSelected = true;
            SubscriptionDialog.this.closeWindow();
        }
    }
}

