/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;

public class SubscriptionSettings
extends ValueModel {
    private Hashtable table = new Hashtable();
    private boolean notifyEnabled = true;

    public boolean equals(SubscriptionSettings subscriptionSettings) {
        if (subscriptionSettings == null) {
            return false;
        }
        if (this.getNumChannels() != subscriptionSettings.getNumChannels()) {
            return false;
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ChannelSettings channelSettings;
            ChannelSettings channelSettings2 = (ChannelSettings)enumeration.nextElement();
            if (channelSettings2.equals(channelSettings = subscriptionSettings.getChannelSettings(channelSettings2.getName()))) continue;
            return false;
        }
        return true;
    }

    public void applySettings(SubscriptionSettings subscriptionSettings) {
        if (!this.equals(subscriptionSettings)) {
            this.setNotifyEnabled(false);
            StringSet stringSet = this.getChannelNames();
            int n = 0;
            while (n < stringSet.size()) {
                if (!subscriptionSettings.contains(stringSet.get(n))) {
                    this.removeChannel(stringSet.get(n));
                }
                ++n;
            }
            Enumeration enumeration = subscriptionSettings.elements();
            while (enumeration.hasMoreElements()) {
                ChannelSettings channelSettings = (ChannelSettings)enumeration.nextElement();
                ChannelSettings channelSettings2 = this.getChannelSettings(channelSettings.getName());
                if (channelSettings2 != null) {
                    channelSettings2.applySettings(channelSettings);
                    continue;
                }
                this.addChannel(new ChannelSettings(channelSettings));
            }
            this.setNotifyEnabled(true);
        }
    }

    public void addChannel(ChannelSettings channelSettings) {
        this.table.put(channelSettings.getName(), channelSettings);
        this.notifyListeners();
    }

    public void removeChannel(ChannelSettings channelSettings) {
        this.removeChannel(channelSettings.getName());
    }

    public void removeChannel(String string) {
        if (this.contains(string)) {
            this.table.remove(string);
            this.notifyListeners();
        }
    }

    public void clear() {
        this.table.clear();
        this.notifyListeners();
    }

    public int getNumChannels() {
        return this.table.size();
    }

    public boolean contains(String string) {
        return this.table.containsKey(string);
    }

    public ChannelSettings getChannelSettings(String string) {
        return (ChannelSettings)this.table.get(string);
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public StringSet getChannelNames() {
        StringSet stringSet = new StringSet();
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            stringSet.add((String)enumeration.nextElement());
        }
        return stringSet;
    }

    public void setNotifyEnabled(boolean bl) {
        this.notifyEnabled = bl;
        this.notifyListeners();
    }

    protected void notifyListeners() {
        if (this.notifyEnabled) {
            super.notifyListeners();
        }
    }
}

