/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextViewer
extends JDialog {
    private boolean neverShown = true;
    private JTextArea jta;

    public TextViewer(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.jta = new JTextArea();
        this.jta.setFont(new Font("MonoSpaced", 0, 12));
        this.jta.setWrapStyleWord(true);
        this.jta.setLineWrap(false);
        this.jta.setTabSize(4);
        this.jta.setEnabled(true);
        this.jta.setEditable(false);
        this.jta.setDisabledTextColor(Color.black);
        this.jta.setText("text not initialized");
        container.add((Component)new JScrollPane(this.jta), "Center");
        JButton jButton = new JButton(" OK ");
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
        jPanel.add(jButton);
        container.add((Component)jPanel, "South");
        jButton.addActionListener(new OkHandler());
        this.addKeyListener(new EscapeMonitor());
        this.pack();
    }

    public void setText(String string) {
        this.jta.setText(string);
    }

    public void loadFile(String string) {
        File file = new File(string);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            this.setText(stringBuffer.toString());
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setText("Cannot find the requested file: " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            stringBuffer.append("I/O Exception reading file " + file.getAbsolutePath());
            stringBuffer.append("\n\n" + iOException.getMessage());
            this.setText(stringBuffer.toString());
        }
    }

    public void loadResource(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            this.setText("Cannot find requested resource: " + string);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            this.setText(stringBuffer.toString());
            bufferedReader.close();
        }
        catch (IOException iOException) {
            stringBuffer.append("I/O Exception reading resource " + string);
            stringBuffer.append("\n\n" + iOException.getMessage());
            this.setText(stringBuffer.toString());
        }
    }

    public void setVisible(boolean bl) {
        if (bl && this.neverShown) {
            this.neverShown = false;
            int n = 600;
            int n2 = 350;
            this.setSize(n, n2);
            this.setLocation(this.getParent().getX() + 40, this.getParent().getY() + 40);
        }
        super.setVisible(bl);
    }

    class EscapeMonitor
    implements KeyListener {
        EscapeMonitor() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                TextViewer.this.setVisible(false);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class OkHandler
    implements ActionListener {
        OkHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextViewer.this.setVisible(false);
        }
    }
}

