/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public class TraceController
extends ControlBar {
    private TraceSettings settings;
    private WaveformManager manager;
    private IntegerModelTextField hscaleField;
    private IntegerModelTextField vscaleField;
    private BooleanModelCheckBox synchBox;
    private BooleanModelCheckBox trackDC;
    private BooleanModelCheckBox autoScale;

    public TraceController(TraceSettings traceSettings, WaveformManager waveformManager) {
        if (traceSettings == null) {
            throw new IllegalArgumentException("null settings in TraceController");
        }
        this.settings = traceSettings;
        this.manager = waveformManager;
        this.hscaleField = new IntegerModelTextField(this.settings.getHScaleModel(), 4);
        this.addLabelledControl(" time width (sec): ", this.hscaleField, false);
        this.synchBox = new BooleanModelCheckBox(" synchronize traces", this.settings.getSynchedModel());
        this.addLabelledControl("", this.synchBox, false);
        JCheckBox jCheckBox = new JCheckBox(" freeze", false);
        jCheckBox.addItemListener(new FreezeAction());
        jCheckBox.setHorizontalTextPosition(2);
        this.addControl(jCheckBox, false);
        this.addStretcher();
        this.vscaleField = new IntegerModelTextField(this.settings.getVScaleModel(), 7);
        this.addLabelledControl(" vertical scale: ", this.vscaleField, false);
        this.trackDC = new BooleanModelCheckBox(" track DC", this.settings.getTrackDCModel());
        this.addLabelledControl("", this.trackDC, false);
        this.autoScale = new BooleanModelCheckBox(" auto", this.settings.getAutoScaleModel());
        this.addLabelledControl("", this.autoScale, false);
        this.settings.getAutoScaleModel().addValueListener(new AutoScaleListener());
    }

    class AutoScaleListener
    implements ValueListener {
        AutoScaleListener() {
        }

        public void valueChanged(Object object) {
            boolean bl = TraceController.this.settings.isAutoScale();
            TraceController.this.vscaleField.setEnabled(!bl);
            TraceController.this.trackDC.setEnabled(!bl);
        }
    }

    class FreezeAction
    implements ItemListener {
        FreezeAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            TraceController.this.manager.setDrawEnabled(itemEvent.getStateChange() == 2);
        }
    }
}

