/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class VectorTableModel
extends AbstractTableModel {
    private Vector rows = new Vector();
    private TableRow rowModel = new EmptyRow();

    public void fireTableDataChanged() {
        super.fireTableDataChanged();
    }

    public void setPrototype(TableRow tableRow) {
        this.rowModel = tableRow == null ? new EmptyRow() : tableRow;
    }

    public void setRows(Vector vector) {
        this.rows.removeAllElements();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof TableRow)) continue;
            this.rows.addElement(e);
        }
        this.fireTableDataChanged();
    }

    public void entryUpdated(TableRow tableRow) {
        int n = this.rows.indexOf(tableRow);
        if (n >= 0) {
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void addRow(TableRow tableRow) {
        if (tableRow != null) {
            this.rows.addElement(tableRow);
        }
        this.fireTableDataChanged();
    }

    public void removeRow(TableRow tableRow) {
        this.rows.removeElement(tableRow);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.rowModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.rowModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.rowModel.getColumnClass(n);
    }

    public Object getValueAt(int n, int n2) {
        TableRow tableRow = (TableRow)this.rows.elementAt(n);
        return tableRow.getValueAt(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        TableRow tableRow = (TableRow)this.rows.elementAt(n);
        tableRow.setValueAt(object, n2);
    }

    public boolean isCellEditable(int n, int n2) {
        TableRow tableRow = (TableRow)this.rows.elementAt(n);
        return tableRow.isCellEditable(n2);
    }

    public Enumeration elements() {
        return this.rows.elements();
    }

    private class EmptyRow
    implements TableRow {
        private EmptyRow() {
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int n) {
            return "Invalid";
        }

        public Class getColumnClass(int n) {
            return null;
        }

        public TableCellRenderer getColumnRenderer(int n) {
            return null;
        }

        public boolean isCellEditable(int n) {
            return false;
        }

        public Object getValueAt(int n) {
            return null;
        }

        public void setValueAt(Object object, int n) {
        }

        public int getPreferredWidth(int n) {
            return 50;
        }
    }
}

