/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.MsgClient;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class WaveformApp
extends BasicFrame {
    public static final String appName = "Nanometrics Waveform";
    public static final String appVersion = "Nanometrics Waveform v 2.05";
    public static final String copyright = "Copyright 1999-2003, Nanometrics Inc.";
    private WaveformManager manager;
    private MsgClient receiver;
    private WaveformSettings settings;
    private SettingsManager settingsMgr;
    private TextViewer textViewer = null;

    public WaveformApp(String string, WaveformSettings waveformSettings) {
        super(string);
        Accessible accessible;
        this.settings = waveformSettings;
        if (this.settings == null) {
            this.settings = new WaveformSettings();
        }
        this.settingsMgr = new SettingsManager(this.settings, this);
        this.updateTitle();
        URL uRL = this.getClass().getResource("/images/waveform.gif");
        if (uRL != null) {
            accessible = new ImageIcon(uRL);
            this.setIconImage(accessible.getImage());
        }
        this.manager = new WaveformManager(this.settings.getTraceSettings(), this.settings.getSubscriptionSettings());
        this.getContentPane().add((Component)this.manager.getTracePanel(), "Center");
        accessible = new TraceController(this.settings.getTraceSettings(), this.manager);
        this.getContentPane().add((Component)((Object)accessible), "North");
        this.setJMenuBar(this.createMenuBar());
        this.receiver = new MsgClient();
        ConnectionController connectionController = new ConnectionController(this.receiver, this.settings.getConnectionSettings());
        this.getContentPane().add((Component)connectionController, "South");
        this.manager.subscribeTo(this.receiver);
        this.receiver.start();
        this.manager.start();
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorder(BorderFactory.createEtchedBorder());
        NmxMenu nmxMenu = new NmxMenu("File", 'F');
        JMenuItem jMenuItem = nmxMenu.add("Load Settings...");
        jMenuItem.setMnemonic('O');
        jMenuItem.addActionListener(new LoadAction());
        jMenuItem = nmxMenu.add("Save Settings");
        jMenuItem.setMnemonic('S');
        jMenuItem.addActionListener(new SaveAction());
        jMenuItem = nmxMenu.add("Save As...");
        jMenuItem.setMnemonic('A');
        jMenuItem.addActionListener(new SaveAsAction());
        nmxMenu.addSeparator();
        jMenuItem = nmxMenu.add("Exit");
        jMenuItem.setMnemonic('X');
        jMenuItem.addActionListener(new ExitAction());
        jMenuBar.add(nmxMenu);
        nmxMenu = new NmxMenu("Trace", 'T');
        jMenuItem = nmxMenu.add(new SubscribeAction(this.manager, this));
        jMenuItem.setMnemonic('S');
        jMenuItem = nmxMenu.add(new UnsubscribeAllAction());
        jMenuItem.setMnemonic('U');
        nmxMenu.addSeparator();
        jMenuItem = nmxMenu.add("Reset");
        jMenuItem.setMnemonic('R');
        jMenuItem.addActionListener(new ResetAction());
        jMenuBar.add(nmxMenu);
        nmxMenu = new NmxMenu("Help", 'H');
        jMenuItem = nmxMenu.add(new HelpAction());
        jMenuItem.setMnemonic('P');
        nmxMenu.addSeparator();
        jMenuItem = nmxMenu.add(new AboutAction(this, "About Waveform", appVersion, copyright));
        jMenuItem.setMnemonic('A');
        jMenuBar.add(nmxMenu);
        return jMenuBar;
    }

    protected void closeWindow() {
        this.settings.setWindowBounds(this.getBounds());
        this.settings.autoSave();
        this.receiver.stop();
        this.manager.stop();
        super.closeWindow();
    }

    public void updateTitle() {
        if (this.settings.getFile() != null) {
            this.setTitle("Nanometrics Waveform - " + this.settings.getFileName());
        } else {
            this.setTitle(appName);
        }
    }

    public static void main(String[] stringArray) {
        NmxSplash nmxSplash = new NmxSplash(appVersion, copyright, "/images/nmxdan.gif");
        String string = "waveform.ini";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        WaveformSettings waveformSettings = WaveformSettings.loadWaveformSettings(string);
        WaveformApp waveformApp = new WaveformApp(appName, waveformSettings);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > 1000) {
            waveformApp.setSize(800, 600);
        } else {
            waveformApp.setSize(600, 450);
        }
        waveformApp.setVisible(true);
        Rectangle rectangle = waveformSettings.getWindowBounds();
        int n = 100;
        if (rectangle.x + n <= dimension.width && rectangle.x + rectangle.width >= n && rectangle.y + n <= dimension.height && rectangle.y + rectangle.height >= n) {
            waveformApp.setBounds(rectangle);
            waveformApp.validate();
        }
        nmxSplash.setVisible(false);
    }

    class ExitAction
    implements ActionListener {
        ExitAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WaveformApp.this.closeWindow();
        }
    }

    class SaveAsAction
    implements ActionListener {
        SaveAsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WaveformApp.this.settingsMgr.doSaveAsAction();
            WaveformApp.this.updateTitle();
        }
    }

    class SaveAction
    implements ActionListener {
        SaveAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WaveformApp.this.settingsMgr.doSaveAction();
            WaveformApp.this.updateTitle();
        }
    }

    class LoadAction
    implements ActionListener {
        LoadAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WaveformApp.this.settingsMgr.doLoadAction();
            WaveformApp.this.updateTitle();
        }
    }

    class UnsubscribeAllAction
    extends AbstractAction {
        public UnsubscribeAllAction() {
            super("Unsubscribe All");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WaveformApp.this.manager.setSelectedChannels(new StringSet());
        }
    }

    class ResetAction
    implements ActionListener {
        ResetAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WaveformApp.this.manager.setStartTime(0.0);
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            super("Help Topics");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (WaveformApp.this.textViewer == null) {
                WaveformApp.this.textViewer = new TextViewer(WaveformApp.this, "Waveform Help", false);
                WaveformApp.this.textViewer.loadResource("/waveform.doc");
            }
            WaveformApp.this.textViewer.setVisible(true);
            WaveformApp.this.textViewer.toFront();
        }
    }
}

