/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.util.NmxDateFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WaveformHeader
extends JPanel {
    private JLabel nameLabel = new JLabel("name");
    private JLabel startLabel = new JLabel("start");
    private JLabel maxLabel = new JLabel(" Max:");
    private JLabel minLabel = new JLabel(" Min:");
    private JLabel avgLabel = new JLabel(" Avg:");
    private JLabel rmsLabel = new JLabel(" RMS:");
    private NmxDateFormat dateFormat = new NmxDateFormat();
    private DecimalFormat decFormat = new DecimalFormat("#0.00");

    public WaveformHeader(String string) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.nameLabel.setFont(new Font("Dialog", 1, 16));
        this.nameLabel.setForeground(Color.blue);
        this.nameLabel.setHorizontalAlignment(0);
        this.maxLabel.setFont(new Font("Dialog", 0, 11));
        this.maxLabel.setForeground(Color.black);
        this.minLabel.setFont(new Font("Dialog", 0, 11));
        this.minLabel.setForeground(Color.black);
        this.avgLabel.setFont(new Font("Dialog", 0, 11));
        this.avgLabel.setForeground(Color.black);
        this.rmsLabel.setFont(new Font("Dialog", 0, 11));
        this.rmsLabel.setForeground(Color.black);
        this.startLabel.setFont(new Font("Dialog", 0, 11));
        this.startLabel.setForeground(Color.black);
        this.startLabel.setHorizontalAlignment(4);
        this.initLayout();
        this.setName(string);
    }

    protected void initLayout() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(4, 1));
        jPanel.add(this.maxLabel);
        jPanel.add(this.minLabel);
        jPanel.add(this.avgLabel);
        jPanel.add(this.rmsLabel);
        int n = this.getLabelWidth();
        jPanel.setMinimumSize(new Dimension(n, 60));
        jPanel.setPreferredSize(new Dimension(n, 60));
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel2 = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel2.add(jPanel);
        this.add((Component)this.nameLabel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)this.startLabel, "South");
    }

    protected int getLabelWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.maxLabel.getFont());
        int n = fontMetrics.stringWidth("RMS: -9999999.99");
        int n2 = fontMetrics.stringWidth("Max: -2123123123");
        return n2 > n ? n2 : n;
    }

    public int getPreferredWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.nameLabel.getFont());
        int n = fontMetrics.stringWidth("MMMMM.MMM");
        fontMetrics = this.getFontMetrics(this.startLabel.getFont());
        int n2 = fontMetrics.stringWidth(this.dateFormat.format(new Date()));
        int n3 = this.getLabelWidth();
        if (n3 < n) {
            n3 = n;
        }
        if (n3 < n2) {
            n3 = n2;
        }
        return n3 + 10;
    }

    public void setName(String string) {
        this.nameLabel.setText(string);
    }

    public void setStartTime(double d) {
        this.startLabel.setText(this.dateFormat.format(d));
    }

    public void setMax(int n) {
        this.maxLabel.setText("Max: " + n);
    }

    public void setMin(int n) {
        this.minLabel.setText("Min: " + n);
    }

    protected String formatValue(double d) {
        if (Math.abs(d) < 1.0E7) {
            return this.decFormat.format(d);
        }
        return "" + (int)d;
    }

    public void setAverage(double d) {
        this.avgLabel.setText("Avg: " + this.formatValue(d));
    }

    public void setRMS(double d) {
        this.rmsLabel.setText("RMS: " + this.formatValue(d));
    }
}

