/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.DataAddRequest;
import ca.nanometrics.msg.DataRemoveRequest;
import ca.nanometrics.msg.KeyedChannel;
import ca.nanometrics.msg.MsgConsumer;
import ca.nanometrics.msg.MsgProducer;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BufferedConsumer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WaveformManager
extends BufferedConsumer
implements MsgConsumer,
SubscriptionManager {
    private TraceSettings traceSettings;
    private SubscriptionSettings subscription;
    private ChannelList channelList = new ChannelList();
    private Hashtable panelsByKey = new Hashtable();
    private Hashtable panelsByName = new Hashtable();
    MsgProducer producer;
    private MultiPanel tracePanel = new MultiPanel("waveform ");
    private boolean drawEnabled = true;

    public WaveformManager(TraceSettings traceSettings, SubscriptionSettings subscriptionSettings) {
        super("Waveform Manager");
        this.traceSettings = traceSettings;
        this.subscription = subscriptionSettings;
        this.setupListeners();
    }

    private void setupListeners() {
        this.traceSettings.getHScaleModel().addValueListener(new HScaleListener());
        this.subscription.addValueListener(new SubscriptionListener());
        VScaleListener vScaleListener = new VScaleListener();
        this.traceSettings.getVScaleModel().addValueListener(vScaleListener);
        this.traceSettings.getAutoScaleModel().addValueListener(vScaleListener);
        this.traceSettings.getTrackDCModel().addValueListener(vScaleListener);
    }

    protected void addChannel(ChannelSettings channelSettings) {
        String string = channelSettings.getName();
        WaveformPanel waveformPanel = new WaveformPanel(channelSettings, this.traceSettings, this);
        waveformPanel.setTimeWidth(this.traceSettings.getHScale());
        this.tracePanel.addPanel(waveformPanel);
        this.panelsByName.put(string, waveformPanel);
        this.subscribeChannel(string);
    }

    protected void removeChannel(String string) {
        WaveformPanel waveformPanel = (WaveformPanel)this.panelsByName.remove(string);
        if (waveformPanel != null) {
            this.tracePanel.removePanel(waveformPanel);
        }
        this.unsubscribeChannel(string);
    }

    public WaveformPanel getChannel(int n) {
        return (WaveformPanel)this.panelsByKey.get(new Integer(n));
    }

    public WaveformPanel getChannel(String string) {
        return (WaveformPanel)this.panelsByName.get(string);
    }

    public Enumeration getChannels() {
        return this.panelsByName.elements();
    }

    public String getName() {
        return "all traces";
    }

    public JComponent getTracePanel() {
        return this.tracePanel;
    }

    protected void hscaleChanged() {
        double d = this.traceSettings.getHScale();
        Enumeration enumeration = this.getChannels();
        while (enumeration.hasMoreElements()) {
            WaveformPanel waveformPanel = (WaveformPanel)enumeration.nextElement();
            waveformPanel.setTimeWidth(d);
        }
    }

    protected void vscaleChanged() {
        Enumeration enumeration = this.getChannels();
        while (enumeration.hasMoreElements()) {
            WaveformPanel waveformPanel = (WaveformPanel)enumeration.nextElement();
            waveformPanel.defaultsChanged();
        }
    }

    public void setStartTime(double d) {
        Enumeration enumeration = this.getChannels();
        while (enumeration.hasMoreElements()) {
            WaveformPanel waveformPanel = (WaveformPanel)enumeration.nextElement();
            waveformPanel.setStartTime(d);
        }
    }

    public void subscribeTo(MsgProducer msgProducer) {
        if (this.producer != null) {
            this.producer.removeSubscriber(this);
        }
        this.producer = msgProducer;
        if (this.producer != null) {
            this.producer.addSubscriber(this);
        }
    }

    protected void updateChannelList(ChannelList channelList) {
        this.channelList = channelList;
        this.panelsByKey.clear();
        StringSet stringSet = this.getCurrentChannels();
        int n = 0;
        while (n < stringSet.size()) {
            this.subscribeChannel(stringSet.get(n));
            ++n;
        }
    }

    public void put(Packable packable) {
        if (packable instanceof ChannelList) {
            this.updateChannelList((ChannelList)packable);
        } else if (packable instanceof DataPacket) {
            this.append(packable);
        }
    }

    protected boolean send(Packable packable) {
        if (this.producer != null) {
            return this.producer.acceptRequest(packable);
        }
        return false;
    }

    protected void process(Object object) {
        if (this.drawEnabled) {
            this.processPacket((DataPacket)object);
        }
    }

    private void processPacket(DataPacket dataPacket) {
        final DataPacket dataPacket2 = dataPacket;
        Runnable runnable = new Runnable(){

            public void run() {
                int n = dataPacket2.getKey();
                WaveformPanel waveformPanel = WaveformManager.this.getChannel(n);
                if (waveformPanel == null) {
                    return;
                }
                waveformPanel.put(dataPacket2);
                if (WaveformManager.this.traceSettings.isSynched()) {
                    WaveformManager.this.setStartTime(waveformPanel.getStartTime());
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {}
    }

    protected void tick() {
        Enumeration enumeration = this.getChannels();
        while (enumeration.hasMoreElements()) {
            WaveformPanel waveformPanel = (WaveformPanel)enumeration.nextElement();
            waveformPanel.tick();
        }
    }

    public StringSet getAvailableChannels() {
        StringSet stringSet = new StringSet();
        Enumeration enumeration = this.channelList.elements();
        while (enumeration.hasMoreElements()) {
            KeyedChannel keyedChannel = (KeyedChannel)enumeration.nextElement();
            if (ChannelKey.getTypeOf(keyedChannel.getKey()) != 1) continue;
            stringSet.add(keyedChannel.getName());
        }
        return stringSet;
    }

    public StringSet getCurrentChannels() {
        StringSet stringSet = new StringSet();
        Enumeration enumeration = this.panelsByName.keys();
        while (enumeration.hasMoreElements()) {
            stringSet.add((String)enumeration.nextElement());
        }
        return stringSet;
    }

    public void setSelectedChannels(StringSet stringSet) {
        this.subscription.setNotifyEnabled(false);
        StringSet stringSet2 = this.getCurrentChannels();
        stringSet2.remove(stringSet);
        int n = 0;
        while (n < stringSet2.size()) {
            this.subscription.removeChannel(stringSet2.get(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < stringSet.size()) {
            String string = stringSet.get(n2);
            if (!this.subscription.contains(string)) {
                this.subscription.addChannel(new ChannelSettings(string, this.traceSettings.getVScale(), this.traceSettings.isTrackDC(), this.traceSettings.isAutoScale(), true));
            }
            ++n2;
        }
        this.subscription.setNotifyEnabled(true);
    }

    protected void updateSubscription() {
        Object object;
        StringSet stringSet = this.getCurrentChannels();
        int n = 0;
        while (n < stringSet.size()) {
            object = stringSet.get(n);
            if (!this.subscription.contains((String)object)) {
                this.removeChannel((String)object);
            }
            ++n;
        }
        object = this.subscription.elements();
        while (object.hasMoreElements()) {
            ChannelSettings channelSettings = (ChannelSettings)object.nextElement();
            String string = channelSettings.getName();
            WaveformPanel waveformPanel = this.getChannel(string);
            if (waveformPanel != null) continue;
            this.addChannel(channelSettings);
        }
    }

    protected void subscribeChannel(String string) {
        int n = this.channelList.getKeyOf(string);
        if (n != -1) {
            WaveformPanel waveformPanel = this.getChannel(string);
            waveformPanel.setKey(n);
            this.panelsByKey.put(new Integer(n), waveformPanel);
            int[] nArray = new int[]{n};
            this.send(new DataAddRequest(nArray, -1, -1, false));
        }
    }

    protected void unsubscribeChannel(String string) {
        int n = this.channelList.getKeyOf(string);
        if (n != -1) {
            this.panelsByKey.remove(new Integer(n));
            int[] nArray = new int[]{n};
            this.send(new DataRemoveRequest(nArray));
        }
    }

    public void unsubscribe(String string) {
        this.subscription.removeChannel(string);
    }

    public void setDrawEnabled(boolean bl) {
        this.drawEnabled = bl;
    }

    public void finalize(String string) {
        this.panelsByKey.clear();
        this.panelsByName.clear();
        this.tracePanel.removeAll();
    }

    class SubscriptionListener
    implements ValueListener {
        SubscriptionListener() {
        }

        public void valueChanged(Object object) {
            WaveformManager.this.updateSubscription();
        }
    }

    class VScaleListener
    implements ValueListener {
        VScaleListener() {
        }

        public void valueChanged(Object object) {
            WaveformManager.this.vscaleChanged();
        }
    }

    class HScaleListener
    implements ValueListener {
        HScaleListener() {
        }

        public void valueChanged(Object object) {
            WaveformManager.this.hscaleChanged();
        }
    }
}

