/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.DataPacketHandler;
import ca.nanometrics.util.NmxDateFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;

public class WaveformPanel
extends JPanel
implements DataPacketHandler {
    private ChannelSettings settings;
    private ScaleSettings defaults;
    SubscriptionManager manager = null;
    private String name;
    private int key;
    private double startTime = 0.0;
    private double timeWidth = 1.0;
    private double verticalScale = 1.0;
    private double verticalOffset = 0.0;
    private double dataStart = 0.0;
    private int imageLeft = 0;
    private int imageWidth = 0;
    private double xLPtoDP = 0.0;
    private double xDPtoLP = 0.0;
    private int imageTop = 0;
    private int imageHeight = 0;
    private double dataTop = 0.0;
    private double yLPtoDP = 0.0;
    private double yDPtoLP = 0.0;
    private SampleStatistics[] pixStats;
    private SampleStatistics stats = new SampleStatistics();
    private WaveformHeader headerPanel;
    private ImagePanel imagePanel;
    private RulerPanel rulerPanel;
    private JPopupMenu popup;
    private BooleanModelMenuItem defScale;
    private BooleanModelMenuItem autoScale;
    private BooleanModelMenuItem trackDC;
    private IntegerModelTextField vscaleField;
    private NmxDateFormat dateFormat = new NmxDateFormat();
    private int titleWidth = 160;

    public WaveformPanel(ChannelSettings channelSettings, ScaleSettings scaleSettings, SubscriptionManager subscriptionManager) {
        this.settings = channelSettings;
        this.defaults = scaleSettings;
        this.manager = subscriptionManager;
        this.name = this.settings.getName();
        this.key = -1;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(null);
        this.headerPanel = new WaveformHeader(this.name);
        this.titleWidth = this.headerPanel.getPreferredWidth();
        this.add(this.headerPanel);
        this.headerPanel.setBounds(0, 0, this.titleWidth, this.getHeight());
        this.imagePanel = new ImagePanel();
        this.add(this.imagePanel);
        this.imagePanel.setBounds(this.titleWidth, 1, this.getWidth() - this.titleWidth - 1, this.getHeight() - 2 - 10);
        this.rulerPanel = new RulerPanel();
        this.add(this.rulerPanel);
        this.rulerPanel.setBounds(this.titleWidth, 1 + this.imagePanel.getHeight(), this.getWidth() - this.titleWidth - 1, 10);
        this.createPopupMenu();
        this.setStartTime(0.0);
        this.setTimeWidth(1.0);
        this.setToolTipText(this.name);
        this.setMinimumSize(new Dimension(this.titleWidth, 50));
        this.addComponentListener(new WaveformResizer());
        this.addValueListeners();
        this.addMouseMotionListener(new MouseTracker());
    }

    protected void addValueListeners() {
        ScaleListener scaleListener = new ScaleListener();
        this.settings.getVScaleModel().addValueListener(scaleListener);
        this.settings.getTrackDCModel().addValueListener(scaleListener);
        this.settings.getAutoScaleModel().addValueListener(scaleListener);
        this.settings.getUseDefaultModel().addValueListener(scaleListener);
    }

    public void setKey(int n) {
        this.key = n;
    }

    public void createPopupMenu() {
        this.popup = new JPopupMenu();
        this.popup.setBorder(new BevelBorder(0));
        this.defScale = new BooleanModelMenuItem("default scale", this.settings.getUseDefaultModel());
        this.autoScale = new BooleanModelMenuItem("auto scale", this.settings.getAutoScaleModel());
        this.trackDC = new BooleanModelMenuItem("track DC", this.settings.getTrackDCModel());
        this.vscaleField = new IntegerModelTextField(this.settings.getVScaleModel(), 6);
        this.popup.add(this.defScale);
        this.popup.add(this.autoScale);
        this.popup.add(this.trackDC);
        this.popup.addSeparator();
        JMenuItem jMenuItem = this.popup.add(new JMenuItem("Reset"));
        jMenuItem.addActionListener(new ResetAction());
        jMenuItem = this.popup.add(new JMenuItem("Unsubscribe"));
        jMenuItem.addActionListener(new UnsubscribeAction());
        this.popup.insert(new LabelledComponent(" Scale: ", (JComponent)this.vscaleField), 0);
        this.addMouseListener(new MenuPopupAction(this.popup));
    }

    private void plotSamples(double d, int[] nArray, int n, int n2) {
        int n3;
        int n4;
        double d2 = 0.0;
        if (n2 > 0) {
            d2 = 1.0 / (double)n2;
        }
        if ((n4 = (int)Math.ceil((double)n2 * (this.dataStart - d))) < 0) {
            n4 = 0;
        }
        if ((n3 = 1 + (int)Math.floor((double)n2 * (this.dataStart + this.timeWidth - d))) > n) {
            n3 = n;
        }
        if (n4 <= n3) {
            this.updateXmapping();
            int n5 = this.scaleXLPtoDP(d + (double)n4 * d2);
            int n6 = this.scaleXLPtoDP(d + (double)n3 * d2);
            int n7 = n4;
            while (n7 < n3) {
                int n8 = this.scaleXLPtoDP(d + (double)n7 * d2);
                this.pixStats[n8].addSample(nArray[n7]);
                this.stats.addSample(nArray[n7]);
                ++n7;
            }
            this.displayStats();
            if (this.isAutoScale() && ((double)this.stats.getMax() > this.verticalOffset + this.verticalScale || (double)this.stats.getMin() < this.verticalOffset - this.verticalScale)) {
                this.redrawImage();
            } else {
                this.redrawImage(n5, n6 - n5);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected double getRoundedStartTime(double d) {
        double d2 = Math.min(5.0, this.getTimeWidth() / 5.0);
        if ((d2 = Math.rint(d2)) < 1.0) {
            d2 = 1.0;
        }
        TimeTicInfoTable timeTicInfoTable = new TimeTicInfoTable();
        TicInfo ticInfo = timeTicInfoTable.getTicInfo(this.getTimeWidth());
        int n = 0;
        while (n <= 4) {
            double d3 = ticInfo.getTicInc(n);
            if (d3 >= d2) {
                return d3 * Math.ceil(d / d3);
            }
            if ((d3 *= 2.0) >= d2) {
                return d3 * Math.ceil(d / d3);
            }
            ++n;
        }
        return d2 * Math.ceil(d / d2);
    }

    public void put(DataPacket dataPacket) {
        double d = dataPacket.getEndTime() - this.getTimeWidth();
        if (d > this.getStartTime()) {
            this.setStartTime(this.getRoundedStartTime(d));
        }
        this.plotSamples(dataPacket.getStartTime(), dataPacket.getSamples(), dataPacket.getNumSamples(), dataPacket.getSampleRate());
    }

    protected void tick() {
    }

    public String getName() {
        return this.name;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getTimeWidth() {
        return this.timeWidth;
    }

    public double getVerticalScale() {
        return this.verticalScale;
    }

    protected void recomputeStats() {
        this.stats.reset();
        int n = 0;
        while (n < this.imageWidth) {
            this.stats.addSample(this.pixStats[n]);
            ++n;
        }
        this.displayStats();
    }

    protected void displayStats() {
        this.headerPanel.setAverage(this.stats.getAverage());
        this.headerPanel.setRMS(this.stats.getRMS());
        this.headerPanel.setMax(this.stats.getMax());
        this.headerPanel.setMin(this.stats.getMin());
    }

    public void setStartTime(double d) {
        if ((d = Math.ceil(d)) != this.startTime) {
            int n;
            this.startTime = d;
            this.headerPanel.setStartTime(this.startTime);
            this.rulerPanel.setStartSeconds(this.startTime);
            if (this.startTime == 0.0) {
                this.stats.reset();
                this.displayStats();
            }
            if (d < this.dataStart - this.timeWidth || d > this.dataStart + this.timeWidth) {
                n = 0;
                while (n < this.imageWidth) {
                    this.pixStats[n].reset();
                    ++n;
                }
                this.recomputeStats();
                this.dataStart = this.startTime;
                this.redrawImage();
            }
            this.updateXmapping();
            n = this.scaleXLPtoDP(d);
            if (n != 0) {
                if (n >= this.imageWidth || -n >= this.imageWidth) {
                    System.out.println("bad startPix in setStartTime()");
                } else if (n > 0) {
                    int n2 = 0;
                    while (n2 < this.imageWidth - n) {
                        this.pixStats[n2].copy(this.pixStats[n2 + n]);
                        ++n2;
                    }
                    int n3 = this.imageWidth - n;
                    while (n3 < this.imageWidth) {
                        this.pixStats[n3].reset();
                        ++n3;
                    }
                    this.recomputeStats();
                    this.dataStart = this.scaleXDPtoLP(n);
                    this.redrawImage();
                } else if (n < 0) {
                    int n4 = -n;
                    int n5 = this.imageWidth - n4 - 1;
                    while (n5 >= 0) {
                        this.pixStats[n5 + n4].copy(this.pixStats[n5]);
                        --n5;
                    }
                    int n6 = 0;
                    while (n6 < n) {
                        this.pixStats[n6].reset();
                        ++n6;
                    }
                    this.recomputeStats();
                    this.dataStart = this.scaleXDPtoLP(n);
                    this.redrawImage();
                }
            }
        }
    }

    public synchronized void setTimeWidth(double d) {
        if (d > 0.0 && d != this.timeWidth) {
            double d2 = this.startTime + this.timeWidth - d;
            if (this.imageWidth > 0) {
                this.updateXmapping();
                SampleStatistics[] sampleStatisticsArray = new SampleStatistics[this.imageWidth];
                int n = 0;
                while (n < this.imageWidth) {
                    sampleStatisticsArray[n] = new SampleStatistics();
                    ++n;
                }
                if (d > this.timeWidth) {
                    int n2 = 0;
                    while (n2 < this.imageWidth) {
                        double d3 = this.scaleXDPtoLP(n2);
                        int n3 = (int)((d3 - d2) * (double)this.imageWidth / d);
                        try {
                            sampleStatisticsArray[n3].addSample(this.pixStats[n2]);
                        }
                        catch (Exception exception) {
                            System.out.println("setTimeWidth(1) jx = " + n3 + ", ix = " + n2 + ", time = " + d3);
                        }
                        ++n2;
                    }
                } else {
                    int n4 = 0;
                    while (n4 < this.imageWidth) {
                        double d4 = d2 + (double)n4 * d / (double)this.imageWidth;
                        int n5 = this.scaleXLPtoDP(d4);
                        try {
                            sampleStatisticsArray[n4].addSample(this.pixStats[n5]);
                        }
                        catch (Exception exception) {
                            System.out.println("setTimeWidth(2) jx = " + n4 + ", ix = " + n5 + ", time = " + d4);
                        }
                        ++n4;
                    }
                }
                this.pixStats = sampleStatisticsArray;
            }
            this.recomputeStats();
            this.timeWidth = d;
            this.dataStart = this.startTime = d2;
            this.headerPanel.setStartTime(this.startTime);
            this.rulerPanel.setStartSeconds(this.startTime);
            this.rulerPanel.setWidthSeconds(d);
            this.redrawImage();
        }
    }

    protected boolean isAutoScale() {
        if (this.settings.isUseDefault()) {
            return this.defaults.isAutoScale();
        }
        return this.settings.isAutoScale();
    }

    protected void updateScales(ScaleSettings scaleSettings) {
        if (scaleSettings.isAutoScale()) {
            int n;
            int n2 = this.stats.getMin();
            if (n2 < (n = this.stats.getMax())) {
                SimpleRounder simpleRounder = new SimpleRounder(10.0);
                ScalarRange scalarRange = simpleRounder.getRange(n2, n);
                this.verticalOffset = (scalarRange.getMax() + scalarRange.getMin()) / 2.0;
                this.verticalScale = (scalarRange.getMax() - scalarRange.getMin()) / 2.0;
                if (this.verticalScale < 1.0) {
                    this.verticalScale = 1.0;
                }
            } else {
                this.verticalScale = 1000.0;
                this.verticalOffset = 0.0;
            }
        } else {
            this.verticalScale = scaleSettings.getVScale();
            this.verticalOffset = scaleSettings.isTrackDC() ? this.computeVerticalOffset(this.verticalScale, this.stats.getAverage()) : 0.0;
        }
    }

    protected void updateScales() {
        if (this.settings.isUseDefault()) {
            this.updateScales(this.defaults);
        } else {
            this.updateScales(this.settings);
        }
    }

    public void setVerticalScale(double d) {
        if (this.settings.isUseDefault()) {
            this.settings.setVScale((int)d);
        }
    }

    public void setTrackDC(boolean bl) {
        if (this.settings.isUseDefault()) {
            this.settings.setTrackDC(bl);
        }
    }

    public void unsubscribe() {
        if (this.manager != null) {
            this.manager.unsubscribe(this.name);
        }
    }

    protected double computeVerticalOffset(double d, double d2) {
        int n = (int)d;
        int n2 = 1;
        while (n > 30 * n2) {
            n2 *= 10;
        }
        n = (n /= n2) <= 6 ? 1 : (n <= 12 ? 2 : 5);
        return (double)(n *= n2) * Math.rint(d2 / (double)n);
    }

    protected void updateYmapping() {
        this.dataTop = this.verticalScale + this.verticalOffset;
        this.yLPtoDP = (double)(-this.imageHeight) / (2.0 * this.verticalScale);
        this.yDPtoLP = this.imageHeight > 0 ? -2.0 * this.verticalScale / (double)this.imageHeight : 0.0;
    }

    protected void updateXmapping() {
        this.xLPtoDP = (double)this.imageWidth / this.timeWidth;
        this.xDPtoLP = this.imageWidth > 0 ? this.timeWidth / (double)this.imageWidth : 0.0;
    }

    protected int scaleYLPtoDP(double d) {
        return this.imageTop + (int)((d - this.dataTop) * this.yLPtoDP);
    }

    protected double scaleYDPtoLP(int n) {
        return this.dataTop + (double)(n - this.imageTop) * this.yDPtoLP;
    }

    protected int scaleXLPtoDP(double d) {
        return this.imageLeft + (int)((d - this.dataStart) * this.xLPtoDP);
    }

    protected double scaleXDPtoLP(int n) {
        return this.dataStart + (double)(n - this.imageLeft) * this.xDPtoLP;
    }

    private void redrawImage(int n, int n2) {
        int n3;
        int n4;
        int n5;
        Graphics graphics = this.imagePanel.getGraphics();
        if (graphics == null) {
            return;
        }
        if (n2 == this.imageWidth) {
            graphics.clearRect(n, 0, n2, this.imageHeight);
            n5 = this.scaleYLPtoDP(this.verticalOffset);
            graphics.setColor(Color.blue);
            graphics.drawLine(0, n5, this.imageWidth, n5);
        }
        graphics.setColor(Color.black);
        if (n2 == this.imageWidth) {
            n5 = this.scaleYLPtoDP(this.verticalOffset);
            Font font = new Font("dialog", 0, 11);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            graphics.setFont(font);
            n4 = fontMetrics.getHeight() * 2 / 3;
            n3 = this.imageWidth - 4;
            String string = "" + (int)this.verticalOffset;
            graphics.drawString(string, n3 - fontMetrics.stringWidth(string), n4 + n5);
            string = "" + (int)(this.verticalOffset + this.verticalScale);
            graphics.drawString(string, n3 - fontMetrics.stringWidth(string), n4);
        }
        n5 = Integer.MIN_VALUE;
        int n6 = Integer.MAX_VALUE;
        if (n > 0 && this.pixStats[n - 1].getSampleCount() > 0) {
            n5 = this.scaleYLPtoDP(this.pixStats[n - 1].getMin());
            n6 = this.scaleYLPtoDP(this.pixStats[n - 1].getMax());
        }
        int n7 = n;
        while (n7 < n + n2) {
            if (this.pixStats[n7].getSampleCount() > 0) {
                n4 = this.scaleYLPtoDP(this.pixStats[n7].getMin());
                n3 = this.scaleYLPtoDP(this.pixStats[n7].getMax());
                graphics.drawLine(n7, n4 < n6 ? n4 : n6, n7, n3 > n5 ? n3 : n5);
                n5 = n4;
                n6 = n3;
            } else {
                n5 = Integer.MIN_VALUE;
                n6 = Integer.MAX_VALUE;
            }
            ++n7;
        }
        graphics.dispose();
        this.repaint(this.imagePanel.getX() + n, this.imagePanel.getY(), n2, this.imageHeight);
    }

    private void redrawImage() {
        this.updateScales();
        this.updateYmapping();
        this.redrawImage(0, this.imageWidth);
    }

    private void reallocateImage() {
        int n;
        int n2 = this.imagePanel.getWidth();
        if (n2 < 10) {
            n2 = 10;
        }
        if ((n = this.imagePanel.getHeight()) < 10) {
            n = 10;
        }
        Image image = this.createImage(n2, n);
        if (n2 != this.imageWidth) {
            SampleStatistics[] sampleStatisticsArray = new SampleStatistics[n2];
            int n3 = 0;
            while (n3 < n2) {
                sampleStatisticsArray[n3] = new SampleStatistics();
                ++n3;
            }
            if (n2 < this.imageWidth) {
                int n4 = 0;
                while (n4 < this.imageWidth) {
                    int n5 = n4 * n2 / this.imageWidth;
                    sampleStatisticsArray[n5].addSample(this.pixStats[n4]);
                    ++n4;
                }
            } else if (this.imageWidth > 0) {
                int n6 = 0;
                while (n6 < n2) {
                    int n7 = n6 * this.imageWidth / n2;
                    sampleStatisticsArray[n6].addSample(this.pixStats[n7]);
                    ++n6;
                }
            }
            this.pixStats = sampleStatisticsArray;
        }
        this.imageWidth = n2;
        this.imageHeight = n;
        this.recomputeStats();
        this.imagePanel.setImage(image);
        this.redrawImage();
    }

    private void resize() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        this.headerPanel.setSize(this.titleWidth, n2);
        this.imagePanel.setSize(n - this.titleWidth - 1, n2 - 2 - 11);
        this.rulerPanel.setBounds(this.titleWidth, 1 + this.imagePanel.getHeight(), this.getWidth() - this.titleWidth - 1, 11);
        this.reallocateImage();
        this.validate();
    }

    public void defaultsChanged() {
        if (this.settings.isUseDefault()) {
            this.redrawImage();
        }
    }

    class MouseTracker
    extends MouseMotionAdapter {
        MouseTracker() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = WaveformPanel.this.imagePanel.getLocation();
            double d = WaveformPanel.this.scaleXDPtoLP(mouseEvent.getX() - point.x);
            double d2 = WaveformPanel.this.scaleYDPtoLP(mouseEvent.getY() - point.y);
            WaveformPanel.this.setToolTipText(WaveformPanel.this.dateFormat.format(d) + " : " + (int)d2);
        }
    }

    class ScaleListener
    implements ValueListener {
        ScaleListener() {
        }

        public void valueChanged(Object object) {
            boolean bl = !WaveformPanel.this.settings.isUseDefault();
            boolean bl2 = !WaveformPanel.this.settings.isAutoScale();
            WaveformPanel.this.autoScale.setEnabled(bl);
            WaveformPanel.this.vscaleField.setEnabled(bl && bl2);
            WaveformPanel.this.trackDC.setEnabled(bl && bl2);
            WaveformPanel.this.redrawImage();
        }
    }

    class WaveformResizer
    extends ComponentAdapter {
        WaveformResizer() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            WaveformPanel.this.resize();
        }
    }

    class ResetAction
    implements ActionListener {
        ResetAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WaveformPanel.this.setStartTime(0.0);
        }
    }

    class UnsubscribeAction
    implements ActionListener {
        UnsubscribeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WaveformPanel.this.unsubscribe();
        }
    }
}

