/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class WaveformSettings
implements Settings,
Serializable {
    static final long serialVersionUID = -6161919418206886572L;
    private Rectangle windowBounds = new Rectangle();
    private ConnectionSettings connectionSettings = new ConnectionSettings();
    private TraceSettings traceSettings = new TraceSettings();
    private SubscriptionSettings subscriptionSettings = new SubscriptionSettings();
    private transient File sourceFile = new File("waveform.ini");

    public boolean applySettings(Settings settings) {
        if (settings instanceof WaveformSettings) {
            WaveformSettings waveformSettings = (WaveformSettings)settings;
            this.setWindowBounds(waveformSettings.getWindowBounds());
            this.connectionSettings.applySettings(waveformSettings.getConnectionSettings());
            this.traceSettings.applySettings(waveformSettings.getTraceSettings());
            this.subscriptionSettings.applySettings(waveformSettings.getSubscriptionSettings());
            return true;
        }
        return false;
    }

    public boolean isValid(Object object) {
        return object instanceof WaveformSettings;
    }

    public boolean equals(Object object) {
        if (object instanceof WaveformSettings) {
            WaveformSettings waveformSettings = (WaveformSettings)object;
            return this.connectionSettings.equals(waveformSettings.getConnectionSettings()) && this.traceSettings.equals(waveformSettings.getTraceSettings()) && this.subscriptionSettings.equals(waveformSettings.getSubscriptionSettings());
        }
        return false;
    }

    public Settings copy() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            WaveformSettings waveformSettings = (WaveformSettings)objectInputStream.readObject();
            return waveformSettings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setWindowBounds(Rectangle rectangle) {
        this.windowBounds.setBounds(rectangle);
    }

    public Rectangle getWindowBounds() {
        return new Rectangle(this.windowBounds);
    }

    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public TraceSettings getTraceSettings() {
        return this.traceSettings;
    }

    public SubscriptionSettings getSubscriptionSettings() {
        return this.subscriptionSettings;
    }

    protected static Object statload(InputStream inputStream) throws IOException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            inputStream.close();
            if (object instanceof WaveformSettings) {
                return object;
            }
            throw new IOException("file does not contain waveform settings");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("file does not contain waveform settings");
        }
        catch (InvalidClassException invalidClassException) {
            throw new IOException("file does not contain waveform settings");
        }
    }

    public static WaveformSettings loadFromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        WaveformSettings waveformSettings = (WaveformSettings)WaveformSettings.statload(fileInputStream);
        waveformSettings.sourceFile = file;
        return waveformSettings;
    }

    public static WaveformSettings loadWaveformSettings(String string) {
        try {
            return WaveformSettings.loadFromFile(new File(string));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return new WaveformSettings();
        }
    }

    public Settings load(InputStream inputStream) throws IOException {
        return (Settings)WaveformSettings.statload(inputStream);
    }

    public void save() throws IOException {
        this.save(this.sourceFile);
    }

    public void save(File file) throws IOException {
        this.save(new FileOutputStream(file));
    }

    public void save(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
        outputStream.close();
    }

    public void autoSave() {
        try {
            this.save();
        }
        catch (Exception exception) {}
    }

    public File getFile() {
        return this.sourceFile;
    }

    public String getFileName() {
        if (this.sourceFile != null) {
            return this.sourceFile.getAbsolutePath();
        }
        return "";
    }

    public void setFile(File file) {
        this.sourceFile = file;
    }
}

