/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelCommand;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class CalibrationCommand
extends ChannelCommand
implements Packable {
    public static final int MSG_TYPE = 140;
    public static final int FLOAT_SIZE = 4;
    private float frequency;
    private float amplitude;
    private float duration;

    public CalibrationCommand(int[] nArray, String string, double d, double d2, double d3) {
        super(nArray, string);
        this.frequency = (float)d;
        this.amplitude = (float)d2;
        this.duration = (float)d3;
    }

    public CalibrationCommand(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public int getDataType() {
        return 140;
    }

    public int getDataLength() {
        return super.getDataLength() + 4 + 4 + 4;
    }

    public void writeTo(byte[] byArray, int n) {
        super.writeTo(byArray, n);
        BigEndian.writeFloat(byArray, n += super.getDataLength(), this.frequency);
        BigEndian.writeFloat(byArray, n += 4, this.amplitude);
        BigEndian.writeFloat(byArray, n += 4, this.duration);
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        super.readFrom(byArray, n, n2);
        if (byArray.length - (n += super.getDataLength()) < 12) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.frequency = BigEndian.readFloat(byArray, n);
        this.amplitude = BigEndian.readFloat(byArray, n += 4);
        this.duration = BigEndian.readFloat(byArray, n += 4);
    }

    public float getFrequency() {
        return this.frequency;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public float getDuration() {
        return this.duration;
    }
}

