/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class CalibrationInfo {
    private static final int INT_SIZE = 4;
    private static final int FLOAT_SIZE = 4;
    private static final int BYTE_SIZE = 1;
    private static final int TYPE_LENGTH = 16;
    private static final int NAME_LENGTH = 12;
    private int key;
    private String channelName;
    private int mcEnable;
    private double mcDuration = 1.0;
    private int calEnable;
    private int calRelay;
    private int calUnits;
    private double coilResistance;
    private double coilConstant;
    private String sensorName;

    public CalibrationInfo(int n, String string, int n2, double d, int n3, int n4, int n5, double d2, double d3, String string2) {
        this.key = n;
        this.channelName = string;
        this.mcEnable = n2;
        this.mcDuration = d;
        this.calEnable = n3;
        this.calRelay = n4;
        this.calUnits = n5;
        this.coilResistance = d2;
        this.coilConstant = d3;
        this.sensorName = string2;
    }

    public CalibrationInfo(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public void writeTo(byte[] byArray, int n) {
        BigEndian.writeInt(byArray, n, this.key);
        BigEndian.writeString(byArray, n += 4, this.channelName, 12);
        byArray[n += 12] = (byte)this.mcEnable;
        byArray[++n] = (byte)this.calEnable;
        byArray[++n] = (byte)this.calRelay;
        byArray[++n] = (byte)this.calUnits;
        BigEndian.writeFloat(byArray, ++n, (float)this.coilResistance);
        BigEndian.writeFloat(byArray, n += 4, (float)this.coilConstant);
        BigEndian.writeString(byArray, n += 4, this.sensorName, 16);
        BigEndian.writeFloat(byArray, n += 16, (float)this.mcDuration);
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        if (n + this.getDataLength() > byArray.length || this.getDataLength() > n2) {
            throw new InvalidInputException("insufficient data in CalibrationInfo.readFrom()");
        }
        this.key = BigEndian.readInt(byArray, n);
        this.channelName = BigEndian.readString(byArray, n += 4, 12);
        this.mcEnable = byArray[n += 12];
        this.calEnable = byArray[++n];
        this.calRelay = byArray[++n];
        this.calUnits = byArray[++n];
        this.coilResistance = BigEndian.readFloat(byArray, ++n);
        this.coilConstant = BigEndian.readFloat(byArray, n += 4);
        this.sensorName = BigEndian.readString(byArray, n += 4, 16);
        this.mcDuration = BigEndian.readFloat(byArray, n += 16);
    }

    public int getDataLength() {
        return 48;
    }

    public int getKey() {
        return this.key;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public int getMassCenterEnable() {
        return this.mcEnable;
    }

    public double getMassCenterDuration() {
        return this.mcDuration;
    }

    public int getCalEnable() {
        return this.calEnable;
    }

    public int getCalRelay() {
        return this.calRelay & 7;
    }

    public boolean isSharedCoil() {
        return (this.calRelay & 8) != 0;
    }

    public int getCalUnits() {
        return this.calUnits;
    }

    public double getCoilResistance() {
        return this.coilResistance;
    }

    public double getCoilConstant() {
        return this.coilConstant;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public int getInstrumentID() {
        return ChannelKey.getIDOf(this.getKey());
    }
}

