/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.CalibrationInfo;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.util.Enumeration;
import java.util.Hashtable;

public class CalibrationInfoTable
implements Packable {
    public static final int MSG_TYPE = 151;
    public static final int INT_SIZE = 4;
    private Hashtable table = new Hashtable();

    public CalibrationInfoTable() {
    }

    public CalibrationInfoTable(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public CalibrationInfo add(CalibrationInfo calibrationInfo) {
        int n = calibrationInfo.getKey();
        return this.table.put(new Integer(n), calibrationInfo);
    }

    public boolean contains(int n) {
        return this.table.containsKey(new Integer(n));
    }

    public CalibrationInfo get(int n) {
        return (CalibrationInfo)this.table.get(new Integer(n));
    }

    public CalibrationInfo remove(int n) {
        return (CalibrationInfo)this.table.get(new Integer(n));
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public int size() {
        return this.table.size();
    }

    public void writeTo(byte[] byArray, int n) {
        int n2 = this.size();
        BigEndian.writeInt(byArray, n, n2);
        n += 4;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            CalibrationInfo calibrationInfo = (CalibrationInfo)enumeration.nextElement();
            calibrationInfo.writeTo(byArray, n);
            n += calibrationInfo.getDataLength();
        }
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        if (n2 < 4 || n + n2 < byArray.length) {
            throw new InvalidInputException("no data in CalibrationInfoTable.readFrom()");
        }
        int n3 = BigEndian.readInt(byArray, n);
        int n4 = 4;
        int n5 = 0;
        while (n5 < n3) {
            CalibrationInfo calibrationInfo = new CalibrationInfo(byArray, n + n4, n2 - n4);
            this.add(calibrationInfo);
            n4 += calibrationInfo.getDataLength();
            ++n5;
        }
    }

    public int getDataType() {
        return 151;
    }

    public int getDataLength() {
        int n = 4;
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            CalibrationInfo calibrationInfo = (CalibrationInfo)enumeration.nextElement();
            n += calibrationInfo.getDataLength();
        }
        return n;
    }
}

