/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelSet;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class ChannelCommand
extends ChannelSet {
    public static final int LONG_SIZE = 8;
    private long permission = 0L;

    public ChannelCommand(int[] nArray, String string) {
        super(nArray);
        this.permission = ChannelCommand.encode(string);
    }

    public ChannelCommand(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public ChannelCommand() {
    }

    public int getDataLength() {
        return super.getDataLength() + 8;
    }

    public void writeTo(byte[] byArray, int n) {
        super.writeTo(byArray, n);
        BigEndian.writeLong(byArray, n += super.getDataLength(), this.permission);
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        super.readFrom(byArray, n, n2);
        if (byArray.length - (n += super.getDataLength()) < 8) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.permission = BigEndian.readLong(byArray, n);
    }

    public static long encode(String string) {
        long l = 0L;
        if (string.length() < 8) {
            string = string.concat("Req1eSt8");
        }
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < 8) {
            l |= (long)((byArray[n] ^ 0xA5) << 8 * n);
            ++n;
        }
        return l;
    }

    public long getPermission() {
        return this.permission;
    }
}

