/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.KeyedChannel;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class ChannelList
implements Packable {
    public static final int MSG_TYPE = 150;
    public static final int NO_KEY = -1;
    static final int INT_SIZE = 4;
    static final int NAME_SIZE = 12;
    static final int ENTRY_SIZE = 16;
    static final int OFFSET_TO_SIZE = 0;
    static final int OFFSET_TO_DATA = 4;
    private Hashtable table = new Hashtable();

    public ChannelList() {
    }

    public ChannelList(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public void addElement(int n, String string) {
        this.table.put(string, new KeyedChannel(n, string));
    }

    public int size() {
        return this.table.size();
    }

    public boolean contains(int n) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            KeyedChannel keyedChannel = (KeyedChannel)enumeration.nextElement();
            if (n != keyedChannel.getKey()) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string) {
        return this.table.contains(string);
    }

    public String getNameOf(int n) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            KeyedChannel keyedChannel = (KeyedChannel)enumeration.nextElement();
            if (n != keyedChannel.getKey()) continue;
            return keyedChannel.getName();
        }
        return null;
    }

    public int getKeyOf(String string) {
        KeyedChannel keyedChannel = (KeyedChannel)this.table.get(string);
        if (keyedChannel != null) {
            return keyedChannel.getKey();
        }
        return -1;
    }

    public void clear() {
        this.table.clear();
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public Iterator names() {
        return this.table.keySet().iterator();
    }

    public int getDataType() {
        return 150;
    }

    public int getDataLength() {
        return 4 + 16 * this.size();
    }

    public void writeTo(byte[] byArray, int n) {
        BigEndian.writeInt(byArray, n + 0, this.size());
        n += 4;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            KeyedChannel keyedChannel = (KeyedChannel)enumeration.nextElement();
            BigEndian.writeInt(byArray, n, keyedChannel.getKey());
            BigEndian.writeString(byArray, n += 4, keyedChannel.getName(), 12);
            n += 12;
        }
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.clear();
        int n3 = BigEndian.readInt(byArray, n + 0);
        n += 4;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = BigEndian.readInt(byArray, n);
            String string = BigEndian.readString(byArray, n += 4, 12);
            n += 12;
            this.addElement(n5, string);
            ++n4;
        }
    }

    public String toString() {
        return "ChannelList (" + this.size() + " entries)";
    }
}

