/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class ChannelSet {
    static final int INT_SIZE = 4;
    static final int MIN_REQUEST_SIZE = 4;
    private int[] chnlKeys;

    public ChannelSet(int[] nArray) {
        this.chnlKeys = new int[nArray.length];
        System.arraycopy(nArray, 0, this.chnlKeys, 0, nArray.length);
    }

    public ChannelSet(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public ChannelSet() {
        this.chnlKeys = new int[0];
    }

    public int getDataLength() {
        return 4 + 4 * this.chnlKeys.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        if (n2 < 4) throw new InvalidInputException("readFrom: insufficient data");
        int n3 = BigEndian.readInt(byArray, n);
        if (n3 * 4 > n2 - 4) throw new InvalidInputException("readFrom: insufficient data");
        this.chnlKeys = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.chnlKeys[n4] = BigEndian.readInt(byArray, n + (n4 + 1) * 4);
            ++n4;
        }
    }

    public void writeTo(byte[] byArray, int n) {
        BigEndian.writeInt(byArray, n, this.chnlKeys.length);
        int n2 = 0;
        while (n2 < this.chnlKeys.length) {
            BigEndian.writeInt(byArray, n + (n2 + 1) * 4, this.chnlKeys[n2]);
            ++n2;
        }
    }

    public int[] getChannels() {
        return this.chnlKeys;
    }

    public int getChannelCount() {
        return this.chnlKeys.length;
    }
}

