/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.DefaultMessageDecoder;
import ca.nanometrics.msg.MessageDecoder;
import ca.nanometrics.net.CallbackServer;
import ca.nanometrics.packet.InternetPacketWrapper;
import ca.nanometrics.packet.Packable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class ClientSocket {
    public static final int READ_SIG = 0;
    public static final int READ_TYPE = 1;
    public static final int READ_LENGTH = 2;
    public static final int READ_DATA = 3;
    public static final int READ_COMPLETE = 4;
    public static final int READ_TIMEOUT = 500;
    private InetAddress addr;
    private int port;
    private boolean callback;
    private InternetPacketWrapper pktWrapper;
    private Socket theSocket = null;
    private DataOutputStream out;
    private DataInputStream in;
    private boolean connected = false;
    private int readState = 0;
    private int rcvSig = 0;
    private int rcvType = 0;
    private int rcvLength = 0;
    private int bytesRead = 0;
    private byte[] rcvData;
    private MessageDecoder decoder;

    public ClientSocket(InetAddress inetAddress, int n, boolean bl) {
        this.addr = inetAddress;
        this.port = n;
        this.callback = bl;
        this.pktWrapper = new InternetPacketWrapper();
        this.decoder = new DefaultMessageDecoder();
    }

    public synchronized void setAddress(InetAddress inetAddress, int n, boolean bl) {
        if (this.addr != inetAddress || this.port != n || this.callback != bl) {
            this.close();
        }
        this.addr = inetAddress;
        this.port = n;
        this.callback = bl;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getPort() {
        return this.port;
    }

    public void reconnect() throws IOException {
        if (!this.connected) {
            if (this.addr == null) {
                throw new IOException("null InetAddress in ClientSocket");
            }
            this.theSocket = this.callback ? CallbackServer.connect(this.addr, this.port, 5000) : new Socket(this.addr, this.port);
            this.theSocket.setSoTimeout(500);
            this.out = new DataOutputStream(this.theSocket.getOutputStream());
            this.in = new DataInputStream(this.theSocket.getInputStream());
            this.readState = 0;
            this.connected = true;
        }
    }

    public void send(Packable packable) throws IOException {
        if (!this.connected) {
            throw new IOException("not connected");
        }
        byte[] byArray = this.pktWrapper.makeWrappedPacket(packable);
        this.out.write(byArray);
        this.out.flush();
    }

    public Packable receive() throws IOException {
        if (this.connected) {
            if (this.readState == 0) {
                this.rcvSig = this.in.readInt();
                if (this.rcvSig == 2059197967) {
                    this.readState = 1;
                } else {
                    throw new IOException("invalid packet signature");
                }
            }
            if (this.readState == 1) {
                this.rcvType = this.in.readInt();
                this.readState = 2;
            }
            if (this.readState == 2) {
                this.rcvLength = this.in.readInt();
                this.bytesRead = 0;
                if (this.rcvLength > 0) {
                    this.rcvData = new byte[this.rcvLength];
                    this.readState = 3;
                } else {
                    this.readState = 4;
                }
            }
            if (this.readState == 3) {
                while (this.bytesRead < this.rcvLength) {
                    this.bytesRead += this.in.read(this.rcvData, this.bytesRead, this.rcvLength - this.bytesRead);
                }
                if (this.bytesRead >= this.rcvLength) {
                    this.readState = 4;
                }
            }
            if (this.readState == 4) {
                byte[] byArray = this.rcvData;
                this.rcvData = null;
                this.readState = 0;
                return this.decoder.decodeMessage(this.rcvType, this.rcvLength, byArray);
            }
            throw new IOException("invalid state: " + this.readState);
        }
        throw new IOException("not connected");
    }

    public void close() {
        if (this.connected) {
            try {
                this.theSocket.close();
                this.in.close();
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connected = false;
            this.theSocket = null;
            this.rcvData = null;
        }
    }

    public void finalize() {
        this.close();
    }
}

