/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelRequest;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class DataAddRequest
extends ChannelRequest
implements Packable {
    public static final int MSG_TYPE = 120;
    private int maxDelay;
    private int outputType;
    private boolean wantsBuffers;

    public DataAddRequest(int[] nArray, int n, int n2, boolean bl) {
        super(nArray);
        this.maxDelay = n;
        this.outputType = n2;
        this.wantsBuffers = bl;
    }

    public DataAddRequest(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public int getDataType() {
        return 120;
    }

    public int getDataLength() {
        return super.getDataLength() + 4 + 4 + 4;
    }

    public void writeTo(byte[] byArray, int n) {
        super.writeTo(byArray, n);
        int n2 = this.wantsBuffers ? 1 : 0;
        BigEndian.writeInt(byArray, n += super.getDataLength(), this.maxDelay);
        BigEndian.writeInt(byArray, n + 4, this.outputType);
        BigEndian.writeInt(byArray, n + 8, n2);
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        super.readFrom(byArray, n, n2);
        if (byArray.length - (n += super.getDataLength()) < 12) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.maxDelay = BigEndian.readInt(byArray, n);
        this.outputType = BigEndian.readInt(byArray, n + 4);
        this.wantsBuffers = 1 == BigEndian.readInt(byArray, n + 8);
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public int getOutputType() {
        return this.outputType;
    }

    public boolean wantsBuffers() {
        return this.wantsBuffers;
    }
}

