/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelCommand;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class MassCenterCommand
extends ChannelCommand
implements Packable {
    public static final int MSG_TYPE = 141;
    public static final int FLOAT_SIZE = 4;
    private float duration;

    public MassCenterCommand(int[] nArray, String string, float f) {
        super(nArray, string);
        this.duration = f;
    }

    public MassCenterCommand(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public int getDataType() {
        return 141;
    }

    public int getDataLength() {
        return super.getDataLength() + 4;
    }

    public void writeTo(byte[] byArray, int n) {
        super.writeTo(byArray, n);
        BigEndian.writeFloat(byArray, n += super.getDataLength(), this.duration);
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        super.readFrom(byArray, n, n2);
        if (byArray.length - (n += super.getDataLength()) < 4) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.duration = BigEndian.readFloat(byArray, n);
    }

    public float getDuration() {
        return this.duration;
    }
}

