/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelRequest;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public abstract class NmxpAddRequest
extends ChannelRequest
implements Packable {
    private int maxDelay;
    private boolean wantsBuffers;

    public NmxpAddRequest(int[] nArray, int n, boolean bl) {
        super(nArray);
        this.maxDelay = n;
        this.wantsBuffers = bl;
    }

    public NmxpAddRequest(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public int getDataLength() {
        return super.getDataLength() + 4 + 4;
    }

    public void writeTo(byte[] byArray, int n) {
        super.writeTo(byArray, n);
        int n2 = this.wantsBuffers ? 1 : 0;
        BigEndian.writeInt(byArray, n += super.getDataLength(), this.maxDelay);
        BigEndian.writeInt(byArray, n + 4, n2);
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        super.readFrom(byArray, n, n2);
        if (byArray.length - (n += super.getDataLength()) < 8) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.maxDelay = BigEndian.readInt(byArray, n);
        this.wantsBuffers = 1 == BigEndian.readInt(byArray, n + 4);
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public boolean wantsBuffers() {
        return this.wantsBuffers;
    }
}

