/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TerminateMessage
implements Packable {
    public static final int MSG_TYPE = 200;
    public static final int NORMAL_SHUTDOWN = 1;
    public static final int ERROR_SHUTDOWN = 2;
    public static final int TIMEOUT_SHUTDOWN = 3;
    public static final int INT_SIZE = 4;
    private int termType;
    private byte[] msgBuffer;

    public TerminateMessage(int n, String string) {
        this.termType = n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeBytes(string);
            dataOutputStream.writeByte(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.msgBuffer = byteArrayOutputStream.toByteArray();
    }

    public TerminateMessage(int n) {
        this.termType = n;
        this.msgBuffer = new byte[0];
    }

    public TerminateMessage(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public int getDataType() {
        return 200;
    }

    public int getDataLength() {
        return 4 + this.msgBuffer.length;
    }

    public void writeTo(byte[] byArray, int n) {
        BigEndian.writeInt(byArray, n, this.termType);
        System.arraycopy(this.msgBuffer, 0, byArray, n + 4, this.msgBuffer.length);
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        if (byArray.length - n < 4) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.termType = BigEndian.readInt(byArray, n);
        this.msgBuffer = new byte[n2 - 4];
        System.arraycopy(byArray, n + 4, this.msgBuffer, 0, n2 - 4);
    }

    public String getTermMessage() {
        if (this.msgBuffer.length > 0) {
            return new String(this.msgBuffer, 0, this.msgBuffer.length - 1);
        }
        return "";
    }

    public int getTermType() {
        return this.termType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TerminateMessage (");
        stringBuffer.append(this.termType);
        stringBuffer.append(")");
        String string = this.getTermMessage();
        if (string.length() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

