/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class CallbackServer
extends ServerSocket {
    protected static int MIN_SLEEP = 100;
    protected static int MAX_SLEEP = 2000;
    int maxCallbacks = 5;

    public CallbackServer(int n, int n2, int n3) throws IOException {
        super(n, n2);
        if (n3 > 0) {
            this.maxCallbacks = n3;
        }
    }

    private static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {}
    }

    public Socket accept() throws IOException {
        Socket socket = super.accept();
        InetAddress inetAddress = socket.getInetAddress();
        int n = socket.getPort();
        socket.close();
        int n2 = MIN_SLEEP;
        int n3 = 0;
        while (n3 < this.maxCallbacks) {
            CallbackServer.sleep(n2);
            try {
                socket = new Socket(inetAddress, n);
                return socket;
            }
            catch (IOException iOException) {
                if ((n2 *= 2) > MAX_SLEEP) {
                    n2 = MAX_SLEEP;
                }
                ++n3;
            }
        }
        throw new IOException("Callback connection refused after " + this.maxCallbacks + " tries");
    }

    public static Socket connect(InetAddress inetAddress, int n, int n2) throws IOException {
        Socket socket = new Socket(inetAddress, n);
        int n3 = socket.getLocalPort();
        socket.close();
        ServerSocket serverSocket = new ServerSocket(n3, 5);
        serverSocket.setSoTimeout(n2);
        socket = serverSocket.accept();
        serverSocket.close();
        return socket;
    }
}

