/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Instrument;

public class ChannelKey {
    public static final int DATA_PACKET = 1;
    public static final int SOH_PACKET = 2;
    public static final int TIME_PACKET = 4;
    public static final int LOG_PACKET = 5;
    public static final int SERIAL_PACKET = 6;
    public static final int FILLER_PACKET = 9;
    protected static final String[] dataTypes = new String[]{"invalid", "data", "soh", "invalid", "time", "log", "serial"};
    private int key;

    public ChannelKey(int n) {
        this.key = n;
    }

    public ChannelKey(int n, int n2, int n3) {
        this.key = ChannelKey.getKeyOf(n, n2, n3);
    }

    public int getID() {
        return ChannelKey.getIDOf(this.key);
    }

    public int getType() {
        return ChannelKey.getTypeOf(this.key);
    }

    public int getChannel() {
        return ChannelKey.getChannelOf(this.key);
    }

    public int getModel() {
        return ChannelKey.getModelOf(this.key);
    }

    public String toString() {
        return ChannelKey.getKeyStringOf(this.key);
    }

    public static int getKeyOf(int n, int n2, int n3) {
        return n3 << 16 | (n & 0xFF) << 8 | n2 & 0xFF;
    }

    public static int getIDOf(int n) {
        return n >> 16 & 0xFFFF;
    }

    public static int getTypeOf(int n) {
        return n >> 8 & 0xFF;
    }

    public static int getChannelOf(int n) {
        return n & 0xFF;
    }

    public static int getModelOf(int n) {
        return Instrument.getModelOf(ChannelKey.getIDOf(n));
    }

    public static String getKeyStringOf(int n) {
        int n2 = ChannelKey.getIDOf(n);
        int n3 = ChannelKey.getTypeOf(n);
        String string = String.valueOf(n3);
        if (n3 < dataTypes.length) {
            string = dataTypes[n3];
        }
        int n4 = ChannelKey.getChannelOf(n);
        if (n3 == 1) {
            ++n4;
        }
        if (n3 == 6 && n4 >= 16) {
            string = "auth";
            n4 -= 15;
        }
        return Instrument.getNameOf(n2) + ":" + string + " " + n4;
    }
}

