/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.SampleRateTable;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class DataPacket
extends NmxPacket {
    public static final int PACKET_TYPE = 1;
    public static final String SUBTYPE_NAME = "Data";
    public static final int FILE_TAG = 43;
    static final byte CHANNEL_MASK = 7;
    static final int RATE_MASK = 248;
    static final byte RATE_SHIFT = 3;
    static final byte BYTE_PACKING = 1;
    static final byte SHORT_PACKING = 2;
    static final byte LONG_PACKING = 3;
    static int[] samplesPerMiniX = new int[]{0, 4, 2, 1, 4, 8, 6, 5, 2, 6, 4, 3, 1, 5, 3, 2, 4, 8, 6, 5, 8, 12, 10, 9, 6, 10, 8, 7, 5, 9, 7, 6, 2, 6, 4, 3, 6, 10, 8, 7, 4, 8, 6, 5, 3, 7, 5, 4, 1, 5, 3, 2, 5, 9, 7, 6, 3, 7, 5, 4, 2, 6, 4, 3, 4, 8, 6, 5, 8, 12, 10, 9, 6, 10, 8, 7, 5, 9, 7, 6, 8, 12, 10, 9, 12, 16, 14, 13, 10, 14, 12, 11, 9, 13, 11, 10, 6, 10, 8, 7, 10, 14, 12, 11, 8, 12, 10, 9, 7, 11, 9, 8, 5, 9, 7, 6, 9, 13, 11, 10, 7, 11, 9, 8, 6, 10, 8, 7, 2, 6, 4, 3, 6, 10, 8, 7, 4, 8, 6, 5, 3, 7, 5, 4, 6, 10, 8, 7, 10, 14, 12, 11, 8, 12, 10, 9, 7, 11, 9, 8, 4, 8, 6, 5, 8, 12, 10, 9, 6, 10, 8, 7, 5, 9, 7, 6, 3, 7, 5, 4, 7, 11, 9, 8, 5, 9, 7, 6, 4, 8, 6, 5, 1, 5, 3, 2, 5, 9, 7, 6, 3, 7, 5, 4, 2, 6, 4, 3, 5, 9, 7, 6, 9, 13, 11, 10, 7, 11, 9, 8, 6, 10, 8, 7, 3, 7, 5, 4, 7, 11, 9, 8, 5, 9, 7, 6, 4, 8, 6, 5, 2, 6, 4, 3, 6, 10, 8, 7, 4, 8, 6, 5, 3, 7, 5, 4};

    public DataPacket(byte[] byArray, int n) throws InvalidInputException {
        super(byArray, n);
    }

    public DataPacket(byte[] byArray, int n, int n2) throws InvalidInputException {
        super(byArray, n, n2);
    }

    protected boolean isLengthOk(int n) {
        return n > 17 && n <= 1020 && n % 17 == 0;
    }

    public boolean isExtendedHeader() {
        return this.guts.length > 17 && this.guts[17] == 0;
    }

    public int getChannel() {
        return this.guts[13] & 7;
    }

    public String getSubTypeName() {
        return SUBTYPE_NAME;
    }

    public int getTimeFraction() {
        return LittleEndian.readShort(this.guts, 5);
    }

    public int getSampleRate() {
        int n = (this.guts[13] & 0xF8) >> 3;
        return SampleRateTable.getSampleRate(n);
    }

    public int getNumSamples() {
        int n = this.getNumBundles();
        int n2 = 0;
        int n3 = 1;
        while (n3 <= n) {
            int n4 = this.guts[n3 * 17] & 0xFF;
            if (n4 == 9) break;
            n2 += samplesPerMiniX[n4];
            ++n3;
        }
        return n2;
    }

    public double getSampleTime(int n) {
        if (this.getLongSeconds() == 0L) {
            return 0.0;
        }
        return this.getPacketTime() + (double)n / (double)this.getSampleRate();
    }

    public double getStartTime() {
        return this.getSampleTime(1);
    }

    public double getEndTime() {
        return this.getSampleTime(this.getNumSamples());
    }

    public int getDataSample() {
        if (this.isExtendedHeader()) {
            return LittleEndian.readInt(this.guts, 18);
        }
        return LittleEndian.readInt24(this.guts, 14);
    }

    int getXCode(int n, int n2) {
        return n >> 2 * (3 - n2) & 3;
    }

    public int[] getSamples() {
        int n = this.getNumSamples();
        if (n < 0) {
            n = 0;
        }
        int n2 = this.getNumBundles();
        int[] nArray = new int[n];
        int n3 = this.getDataSample();
        int n4 = 0;
        int n5 = 1;
        while (n5 <= n2) {
            int n6 = n5 * 17;
            int n7 = this.guts[n6] & 0xFF;
            if (n7 == 9) break;
            ++n6;
            int n8 = 0;
            while (n8 < 4) {
                int n9 = this.getXCode(n7, n8);
                switch (n9) {
                    case 1: {
                        nArray[n4++] = n3 += this.guts[n6];
                        nArray[n4++] = n3 += this.guts[++n6];
                        nArray[n4++] = n3 += this.guts[++n6];
                        nArray[n4++] = n3 += this.guts[++n6];
                        ++n6;
                        break;
                    }
                    case 2: {
                        nArray[n4++] = n3 += LittleEndian.readShort(this.guts, n6);
                        nArray[n4++] = n3 += LittleEndian.readShort(this.guts, n6 += 2);
                        n6 += 2;
                        break;
                    }
                    case 3: {
                        nArray[n4++] = n3 += LittleEndian.readInt(this.guts, n6);
                        n6 += 4;
                    }
                }
                ++n8;
            }
            ++n5;
        }
        return nArray;
    }

    public String toString() {
        String string = this.getInstrumentName() + "-" + this.getChannel() + ":" + this.getSequenceNumber() + " @ " + this.getTimeString(this.getStartTime()) + "  " + this.getNumSamples() + " samples at " + this.getSampleRate() + " sps";
        return string;
    }
}

