/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.Instrument;
import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;

public class DecompDataPacket
extends Packet {
    public static final int MSG_TYPE = 4;
    static final int KEY_POSITION = 0;
    static final int TIME_POSITION = 4;
    static final int COUNT_POSITION = 12;
    static final int RATE_POSITION = 16;
    static final int DATA_POSITION = 20;
    int key;
    double startTime;
    int[] samples;
    int numSamples;
    int sampleRate;

    public DecompDataPacket(int n, double d, int[] nArray, int n2, int n3) {
        this.key = n;
        this.startTime = d;
        this.numSamples = n2;
        this.sampleRate = n3;
        this.samples = new int[n2];
        System.arraycopy(nArray, 0, this.samples, 0, n2);
    }

    public DecompDataPacket(DataPacket dataPacket) {
        this.key = dataPacket.getKey();
        this.startTime = dataPacket.getStartTime();
        this.samples = dataPacket.getSamples();
        this.numSamples = this.samples.length;
        this.sampleRate = dataPacket.getSampleRate();
    }

    public DecompDataPacket(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public void writeTo(byte[] byArray, int n) {
        BigEndian.writeInt(byArray, n + 0, this.key);
        BigEndian.writeDouble(byArray, n + 4, this.startTime);
        BigEndian.writeInt(byArray, n + 12, this.numSamples);
        BigEndian.writeInt(byArray, n + 16, this.sampleRate);
        n += 20;
        int n2 = 0;
        while (n2 < this.numSamples) {
            BigEndian.writeInt(byArray, n, this.samples[n2]);
            n += 4;
            ++n2;
        }
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.key = BigEndian.readInt(byArray, n + 0);
        this.startTime = BigEndian.readDouble(byArray, n + 4);
        this.numSamples = BigEndian.readInt(byArray, n + 12);
        this.sampleRate = BigEndian.readInt(byArray, n + 16);
        if (n2 != this.getDataLength()) {
            throw new InvalidInputException("DecompDataPacket");
        }
        this.samples = new int[this.numSamples];
        n += 20;
        int n3 = 0;
        while (n3 < this.numSamples) {
            this.samples[n3] = BigEndian.readInt(byArray, n);
            n += 4;
            ++n3;
        }
    }

    public int getDataType() {
        return 4;
    }

    public int getDataLength() {
        return 20 + 4 * this.numSamples;
    }

    public int getKey() {
        return this.key;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int[] getSamples() {
        int[] nArray = new int[this.numSamples];
        System.arraycopy(this.samples, 0, nArray, 0, this.numSamples);
        return nArray;
    }

    public String toString() {
        Format format = new Format("%03d");
        Format format2 = new Format("%02d");
        Format format3 = new Format("%06.3f");
        int n = this.getKey() >> 16;
        int n2 = Instrument.getModelOf(n);
        int n3 = Instrument.getUnitOf(n);
        int n4 = 1 + (this.getKey() & 0xFF);
        int n5 = (int)this.getStartTime();
        String string = Instrument.getModelNameOf(n2) + format.form(n3) + "-" + n4 + " @ " + format2.form(n5 % 3600 / 60) + ":" + format3.form(this.getStartTime() % 60.0) + "  " + this.getNumSamples() + " samples at " + this.getSampleRate() + " sps";
        return string;
    }
}

