/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.BigEndian;

public class EventPacket
extends Packet {
    public static final int MSG_TYPE = 6;
    private static final int INT_SIZE = 4;
    private static final int DOUBLE_SIZE = 8;
    private static final int NAME_SIZE = 12;
    private int eventType;
    private int triggerType;
    private double start;
    private double duration;
    private String[] chnlNames;

    public EventPacket(int n, int n2, double d, double d2, String[] stringArray) {
        this.eventType = n;
        this.triggerType = n2;
        this.start = d;
        this.duration = d2;
        this.chnlNames = stringArray;
    }

    public EventPacket(byte[] byArray, int n, int n2) {
        this.readFrom(byArray, n, n2);
    }

    public int getDataType() {
        return 6;
    }

    public int getDataLength() {
        return 28 + this.chnlNames.length * 12;
    }

    public void writeTo(byte[] byArray, int n) {
        BigEndian.writeInt(byArray, n, this.eventType);
        BigEndian.writeInt(byArray, n += 4, this.triggerType);
        BigEndian.writeDouble(byArray, n += 4, this.start);
        BigEndian.writeDouble(byArray, n += 8, this.duration);
        BigEndian.writeInt(byArray, n += 8, this.chnlNames.length);
        n += 4;
        int n2 = 0;
        while (n2 < this.chnlNames.length) {
            BigEndian.writeString(byArray, n, this.chnlNames[n2], 12);
            n += 12;
            ++n2;
        }
    }

    public void readFrom(byte[] byArray, int n, int n2) {
        this.eventType = BigEndian.readInt(byArray, n);
        this.triggerType = BigEndian.readInt(byArray, n += 4);
        this.start = BigEndian.readDouble(byArray, n += 4);
        this.duration = BigEndian.readDouble(byArray, n += 8);
        int n3 = BigEndian.readInt(byArray, n += 8);
        this.chnlNames = new String[n3];
        n += 4;
        int n4 = 0;
        while (n4 < n3) {
            this.chnlNames[n4] = BigEndian.readString(byArray, n, 12);
            n += 12;
            ++n4;
        }
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getTrigType() {
        return this.triggerType;
    }

    public double getStart() {
        return this.start;
    }

    public double getDuration() {
        return this.duration;
    }

    public int getTrigCount() {
        return this.chnlNames.length;
    }

    public String[] getNames() {
        return this.chnlNames;
    }
}

