/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.util.Format;

public class Instrument {
    public static final int HRD = 0;
    public static final int ORION = 1;
    public static final int RM3 = 2;
    public static final int RM4 = 3;
    public static final int LYNX = 4;
    public static final int CYGNUS = 5;
    public static final int EUROPA = 6;
    public static final int CARINA = 7;
    public static final int TIMESERVER = 8;
    public static final int TRIDENT = 9;
    public static final int JANUS = 10;
    public static final String[] modelName = new String[]{"HRD", "Orion", "RM3", "RM4", "LYNX", "Cygnus", "Europa", "Carina", "TimeServer", "Trident", "Janus"};
    static final String[] shortName = new String[]{"HRD", "ORN", "RM3", "RM4", "LNX", "CYG", "EUR", "CAR", "TIM", "TRI", "JAN"};
    static final String unknownModel = "UNK";
    static final int UNIT_MASK = 2047;
    static final int MODEL_MASK = 63488;
    static final int MODEL_SHIFT = 11;

    public static String getModelNameFromId(int n) {
        int n2 = Instrument.getModelOf(n);
        return Instrument.getModelNameOf(n2);
    }

    public static String getModelNameOf(int n) {
        if (n >= 0 && n < modelName.length) {
            return modelName[n];
        }
        return unknownModel;
    }

    protected static String getShortNameOf(int n) {
        if (n >= 0 && n < modelName.length) {
            return shortName[n];
        }
        return unknownModel;
    }

    public static int getModelOf(String string) {
        int n = 0;
        while (n < modelName.length) {
            if (string.equalsIgnoreCase(modelName[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int getIDOf(int n, int n2) {
        return n << 11 & 0xF800 | n2 & 0x7FF;
    }

    public static int getModelOf(int n) {
        return (n & 0xF800) >> 11;
    }

    public static int getUnitOf(int n) {
        return n & 0x7FF;
    }

    public static String getNameOf(int n) {
        int n2 = Instrument.getModelOf(n);
        int n3 = Instrument.getUnitOf(n);
        Format format = new Format("%03d");
        return Instrument.getShortNameOf(n2) + format.form(n3);
    }

    public static String getFullNameOf(int n) {
        int n2 = Instrument.getModelOf(n);
        int n3 = Instrument.getUnitOf(n);
        return Instrument.getModelNameOf(n2) + " " + n3;
    }

    public static boolean hasInternalHrd(int n) {
        int n2 = Instrument.getModelOf(n);
        return n2 == 0 || n2 == 1 || n2 == 4 || n2 == 6;
    }

    public static boolean isVSat(int n) {
        int n2 = Instrument.getModelOf(n);
        return n2 == 7 || n2 == 5 || n2 == 4;
    }

    public static boolean isVSatRemote(int n) {
        int n2 = Instrument.getModelOf(n);
        return n2 == 5 || n2 == 4;
    }

    public static boolean isNmxBusDevice(int n) {
        int n2 = Instrument.getModelOf(n);
        return n2 == 8 || n2 == 9;
    }

    public static boolean isController(int n) {
        int n2 = Instrument.getModelOf(n);
        return n2 == 7 || n2 == 5 || n2 == 4 || n2 == 6 || n2 == 10;
    }
}

