/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.packet.PacketWrapper;
import ca.nanometrics.util.BigEndian;

public class InternetPacketWrapper
extends PacketWrapper {
    public static final int NMX_SIGNATURE = 2059197967;
    static final int SIGNATURE_OFFSET = 0;
    static final int DATA_TYPE_OFFSET = 4;
    static final int DATA_LEN_OFFSET = 8;
    private static final int OFFSET_TO_DATA = 12;

    public byte[] makeWrappedPacket(Packable packable) {
        int n = packable.getDataLength();
        int n2 = 12 + n;
        byte[] byArray = new byte[n2];
        BigEndian.writeInt(byArray, 0, 2059197967);
        BigEndian.writeInt(byArray, 4, packable.getDataType());
        BigEndian.writeInt(byArray, 8, packable.getDataLength());
        packable.writeTo(byArray, 12);
        return byArray;
    }

    public boolean isValidPacket(byte[] byArray, int n) {
        return BigEndian.readInt(byArray, 0) == 2059197967 && BigEndian.readInt(byArray, 8) + 12 == n;
    }

    public int getDataOffset() {
        return 12;
    }

    public static int getDataOffsetAsClassConst() {
        return 12;
    }

    public int getDataType(byte[] byArray) {
        return BigEndian.readInt(byArray, 4);
    }

    public int getDataLength(byte[] byArray) {
        return BigEndian.readInt(byArray, 8);
    }
}

