/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Instrument;
import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.IntegerHelper;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;
import ca.nanometrics.util.NmxDateFormat;

public class NmxPacket
extends Packet {
    public static final int MSG_TYPE = 1;
    public static final byte TYPE_MASK = 31;
    public static final byte RETX_MASK = 32;
    public static final int OSN_SIZE = 4;
    public static final int BUNDLE_SIZE = 17;
    public static final int MAX_BUNDLES = 59;
    public static final byte NULL_BUNDLE = 9;
    static final int OFFSET_TO_TIMESECS = 1;
    static final int OFFSET_TO_TIMEFRAC = 5;
    static final int OFFSET_TO_INSTR_ID = 7;
    static final int OFFSET_TO_SEQUENCE = 9;
    public static final String SUBTYPE_NAME = "Nmx";
    byte[] guts;
    int oldestSequence;
    private static NmxDateFormat hms = new NmxDateFormat("HH:mm:ss.SSS");

    public NmxPacket(byte[] byArray, int n) throws InvalidInputException {
        if (!this.isLengthOk(byArray.length)) {
            throw new InvalidInputException("NmxPacket");
        }
        this.guts = byArray;
        this.oldestSequence = n;
    }

    public NmxPacket(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public NmxPacket(byte[] byArray, int n, int n2, int n3, int n4) throws InvalidInputException {
        if (n2 < 0) {
            throw new InvalidInputException("Input To Create NMX packet invalid!: Data Length Specified is Negative!");
        }
        if (n < 0) {
            throw new InvalidInputException("Input To Create NMX packet invalid: Data Offset Specified is Negative!");
        }
        if (n2 != IntegerHelper.nextClosestDivisible(n3 + n4, 17) + 4) {
            throw new InvalidInputException("Input To Create NMX packet invalid: Incorrect length!");
        }
        if (n + n2 > byArray.length) {
            throw new InvalidInputException("Input To Create NMX packet invalid: Data offset+length > buffer length");
        }
        this.readFrom(byArray, n, n2);
    }

    public NmxPacket(NmxPacket nmxPacket) {
        this.oldestSequence = nmxPacket.oldestSequence;
        this.guts = new byte[nmxPacket.guts.length];
        System.arraycopy(nmxPacket.guts, 0, this.guts, 0, this.guts.length);
    }

    public static NmxPacket makeNullPacket(NmxPacket nmxPacket) {
        NmxPacket nmxPacket2 = new NmxPacket(nmxPacket);
        nmxPacket2.guts[17] = 9;
        nmxPacket2.setTimeSeconds(0);
        nmxPacket2.setTimeFraction(0);
        return nmxPacket2;
    }

    protected boolean isLengthOk(int n) {
        return n > 17;
    }

    public int getDataType() {
        return 1;
    }

    public int getDataLength() {
        return 4 + this.guts.length;
    }

    public void writeTo(byte[] byArray, int n) {
        LittleEndian.writeInt(byArray, n, this.oldestSequence);
        System.arraycopy(this.guts, 0, byArray, n + 4, this.guts.length);
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.oldestSequence = LittleEndian.readInt(byArray, n);
        n += 4;
        if (!this.isLengthOk(n2 -= 4)) {
            throw new InvalidInputException("NmxPacket");
        }
        this.guts = new byte[n2];
        System.arraycopy(byArray, n, this.guts, 0, n2);
    }

    public static int getKeyOf(int n, int n2, int n3) {
        return n3 << 16 | (n & 0xFF) << 8 | n2 & 0xFF;
    }

    public static int getTypeOf(byte[] byArray, int n) {
        return byArray[n + 4] & 0x1F;
    }

    public int getKey() {
        return NmxPacket.getKeyOf(this.getType(), this.getChannel(), this.getInstrumentID());
    }

    public int getType() {
        return this.guts[0] & 0x1F;
    }

    public boolean isReTx() {
        return (this.guts[0] & 0x20) == 32;
    }

    public void setReTx(boolean bl) {
        this.guts[0] = bl ? (byte)(this.guts[0] | 0x20) : (byte)(this.guts[0] & 0xFFFFFFDF);
    }

    public int getInstrumentID() {
        return LittleEndian.readShort(this.guts, 7);
    }

    public String getInstrumentName() {
        int n = this.getInstrumentID();
        return Instrument.getNameOf(n);
    }

    public int getChannel() {
        return 0;
    }

    public String getSubTypeName() {
        return SUBTYPE_NAME;
    }

    public void setSequenceNumber(int n) {
        LittleEndian.writeInt(this.guts, 9, n);
    }

    public int getSequenceNumber() {
        return LittleEndian.readInt(this.guts, 9);
    }

    public int getOldestSequence() {
        return this.oldestSequence;
    }

    public void setOldestSequence(int n) {
        this.oldestSequence = n;
    }

    public int getStorableLength() {
        return this.guts.length;
    }

    public int getNumBundles() {
        return this.getStorableLength() / 17 - 1;
    }

    public int getTimeSeconds() {
        return LittleEndian.readInt(this.guts, 1);
    }

    public long getLongSeconds() {
        return LittleEndian.readUInt(this.guts, 1);
    }

    public void setTimeSeconds(int n) {
        LittleEndian.writeInt(this.guts, 1, n);
    }

    public int getTimeFraction() {
        return 0;
    }

    public void setTimeFraction(int n) {
        LittleEndian.writeShort(this.guts, 5, (short)n);
    }

    public double getPacketTime() {
        return (double)this.getLongSeconds() + 1.0E-4 * (double)this.getTimeFraction();
    }

    public byte[] getStorableBytes() {
        return this.guts;
    }

    protected String getTimeString(double d) {
        return hms.format(d);
    }

    protected String getPacketTimeString() {
        return hms.format(this.getPacketTime());
    }

    public byte getStorableByte(int n) {
        return this.guts[n];
    }

    public String toString() {
        String string = this.getInstrumentName() + "-" + this.getSubTypeName() + ":" + this.getSequenceNumber() + " @ " + this.getPacketTimeString();
        return string;
    }
}

