/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.FillerPacket;
import ca.nanometrics.packet.LogPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.SerialPacket;
import ca.nanometrics.packet.SohPacket;
import ca.nanometrics.packet.TimeSyncPacket;
import ca.nanometrics.util.InvalidInputException;

public class NmxPacketFactory {
    static final int DATA_PACKET = 1;
    static final int SOH_PACKET = 2;
    static final int TIME_PACKET = 4;
    static final int LOG_PACKET = 5;
    static final int SERIAL_PACKET = 6;
    static final int FILLER_PACKET = 9;

    public static NmxPacket makePacket(byte[] byArray, int n, int n2) throws InvalidInputException {
        NmxPacket nmxPacket = null;
        try {
            switch (NmxPacket.getTypeOf(byArray, n)) {
                case 1: {
                    nmxPacket = new DataPacket(byArray, n, n2);
                    break;
                }
                case 2: {
                    nmxPacket = new SohPacket(byArray, n, n2);
                    break;
                }
                case 6: {
                    nmxPacket = new SerialPacket(byArray, n, n2);
                    break;
                }
                case 4: {
                    nmxPacket = new TimeSyncPacket(byArray, n, n2);
                    break;
                }
                case 9: {
                    nmxPacket = new FillerPacket(byArray, n, n2);
                    break;
                }
                case 5: {
                    nmxPacket = new LogPacket(byArray, n, n2);
                }
            }
        }
        catch (Exception exception) {
            throw new InvalidInputException("Error in NmxPacketFactory:" + NmxPacket.getTypeOf(byArray, n));
        }
        if (nmxPacket == null) {
            throw new InvalidInputException("Error in NmxPacketFactory: unknown packet type.");
        }
        return nmxPacket;
    }
}

