/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class RawPacket
extends Packet {
    public static final int MSG_TYPE = 20;
    public static final int INT_SIZE = 4;
    private int bodyType;
    private int bodyLength;
    byte[] body;

    public RawPacket(int n, int n2, byte[] byArray) throws InvalidInputException {
        if (n2 < 0) {
            throw new InvalidInputException("RawPacket length < 0");
        }
        if (byArray == null && n2 > 0) {
            throw new InvalidInputException("RawPacket buffer is null");
        }
        this.bodyType = n;
        this.bodyLength = n2;
        this.body = new byte[this.bodyLength];
        if (n2 > 0) {
            System.arraycopy(this.body, 0, byArray, 0, this.bodyLength);
        }
    }

    public RawPacket(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public int getDataType() {
        return 20;
    }

    public int getDataLength() {
        return 4 + this.bodyLength;
    }

    public int getBodyType() {
        return this.bodyType;
    }

    public int getBodyLength() {
        return this.bodyLength;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void writeTo(byte[] byArray, int n) {
        BigEndian.writeInt(byArray, n, this.bodyType);
        System.arraycopy(this.body, 0, byArray, n + 4, this.body.length);
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        if (n2 < 4) {
            throw new InvalidInputException("RawPacket length < 4 bytes");
        }
        this.bodyType = BigEndian.readInt(byArray, n);
        this.bodyLength = n2 - 4;
        if (this.bodyLength > 0) {
            this.body = new byte[this.bodyLength];
            System.arraycopy(byArray, n + 4, this.body, 0, this.bodyLength);
        } else {
            this.body = null;
        }
    }

    public String toString() {
        String string = "RawPacket type " + this.bodyType + ", length " + this.bodyLength;
        return string;
    }
}

