/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class SerialPacket
extends NmxPacket {
    public static final int PACKET_TYPE = 6;
    public static final String SUBTYPE_NAME = "Serial";
    public static final int FILE_TAG = 45;
    static final int OFFSET_TO_BYTECOUNT = 13;
    static final int OFFSET_TO_CHANNEL = 15;
    static final int OFFSET_TO_PAYLOAD = 17;

    public SerialPacket(byte[] byArray, int n) throws InvalidInputException {
        super(byArray, n);
    }

    public SerialPacket(byte[] byArray, int n, int n2) throws InvalidInputException {
        super(byArray, n, n2);
    }

    public int getChannel() {
        return this.guts[15];
    }

    public int getTimeFraction() {
        return LittleEndian.readShort(this.guts, 5);
    }

    public int getPayloadSize() {
        int n = LittleEndian.readShort(this.guts, 13);
        if (n < 0) {
            n = 0;
        }
        if (n > this.guts.length - 17) {
            n = this.guts.length - 17;
        }
        return n;
    }

    public String getSubTypeName() {
        return "S" + this.getChannel();
    }

    public byte[] getPayload() {
        int n = this.getPayloadSize();
        byte[] byArray = new byte[n];
        if (n > 0) {
            System.arraycopy(this.guts, 17, byArray, 0, n);
        }
        return byArray;
    }

    public String toString() {
        String string = this.getInstrumentName() + "-" + this.getSubTypeName() + ":" + this.getSequenceNumber() + " PayloadSize:" + this.getPayloadSize() + " @ " + this.getPacketTimeString();
        int n = this.getChannel();
        if (n >= 16 && n <= 21) {
            if (this.guts[17] == 0) {
                double d = BigEndian.readDouble(this.guts, 61);
                string = string + " stamp: " + this.getTimeString(d);
            } else if (this.guts[17] == 1 && this.guts.length >= 65) {
                boolean bl = true;
                int n2 = 45;
                int n3 = n2 + 20;
                int n4 = n2;
                while (n4 < n3 && bl) {
                    bl &= this.guts[n4] >= 32 && this.guts[n4] < 64;
                    ++n4;
                }
                if (bl) {
                    string = string + " stamp: " + new String(this.guts, n2, 20);
                }
            }
        }
        return string;
    }
}

