/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.util.InvalidInputException;

public class SohPacket
extends NmxPacket {
    public static final int PACKET_TYPE = 2;
    public static final int SOH_CHANNEL = 0;
    public static final String SUBTYPE_NAME = "Soh";
    public static final int FILE_TAG = 44;

    public SohPacket(byte[] byArray, int n) throws InvalidInputException {
        super(byArray, n);
    }

    public SohPacket(byte[] byArray, int n, int n2) throws InvalidInputException {
        super(byArray, n, n2);
    }

    protected boolean isLengthOk(int n) {
        return n > 17 && n <= 1020 && n % 17 == 0;
    }

    public int getChannel() {
        return 0;
    }

    public String getSubTypeName() {
        return SUBTYPE_NAME;
    }

    public byte[] getBundle(int n) {
        byte[] byArray = new byte[17];
        int n2 = n * 17;
        int n3 = 0;
        while (n3 < 17) {
            byArray[n3] = this.guts[n2 + n3];
            ++n3;
        }
        return byArray;
    }

    public String toString() {
        String string = this.getInstrumentName() + "-" + this.getSubTypeName() + ":" + this.getSequenceNumber() + " bundles:" + this.getNumBundles() + " @ " + this.getPacketTimeString();
        return string;
    }
}

