/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.TriggerPacket;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class StaLtaTrigger
extends TriggerPacket {
    private static final int SIZEOF_STNID = 12;
    private static final int OFFSET_TO_STNID = 0;
    private static final int OFFSET_TO_ID = 12;
    private static final int OFFSET_TO_TIME = 16;
    private static final int OFFSET_TO_DURATION = 24;
    private static final int OFFSET_TO_LTA_START = 28;
    private static final int OFFSET_TO_LTA_END = 32;
    private static final int OFFSET_TO_PEAK_STA = 36;
    private static final int OFFSET_TO_PEAK_TO_PEAK = 40;
    private static final int OFFSET_TO_TIME_TO_PEAK = 44;
    private static final int OFFSET_TO_HALF_PERIOD = 48;
    private static final int OFFSET_TO_PHASE = 52;
    private static final int DATA_LENGTH = 56;
    protected static DateFormat dateFormat = null;
    String stnID;
    int triggerID;
    double startTime;
    float duration;
    float ltaAtStart;
    float ltaAtEnd;
    float peakSta;
    float maxPeakToPeak;
    float timeToPeak;
    float halfPeriod;
    int phase;

    public StaLtaTrigger(String string, int n, double d, float f, float f2, float f3, float f4, float f5, float f6, float f7, int n2) {
        this.stnID = string;
        this.triggerID = n;
        this.startTime = d;
        this.duration = f;
        this.ltaAtStart = f2;
        this.ltaAtEnd = f3;
        this.peakSta = f4;
        this.maxPeakToPeak = f5;
        this.timeToPeak = f6;
        this.halfPeriod = f7;
        this.phase = n2;
    }

    public StaLtaTrigger(byte[] byArray, int n, int n2) throws InvalidInputException {
        this.readFrom(byArray, n, n2);
    }

    public void writeTo(byte[] byArray, int n) {
        BigEndian.writeString(byArray, n + 0, this.stnID, 12);
        BigEndian.writeInt(byArray, n + 12, this.triggerID);
        BigEndian.writeDouble(byArray, n + 16, this.startTime);
        BigEndian.writeFloat(byArray, n + 24, this.duration);
        BigEndian.writeFloat(byArray, n + 28, this.ltaAtStart);
        BigEndian.writeFloat(byArray, n + 32, this.ltaAtEnd);
        BigEndian.writeFloat(byArray, n + 36, this.peakSta);
        BigEndian.writeFloat(byArray, n + 40, this.maxPeakToPeak);
        BigEndian.writeFloat(byArray, n + 44, this.timeToPeak);
        BigEndian.writeFloat(byArray, n + 48, this.halfPeriod);
        BigEndian.writeInt(byArray, n + 52, this.phase);
    }

    public void readFrom(byte[] byArray, int n, int n2) throws InvalidInputException {
        if (n2 != this.getDataLength() || byArray.length < n + n2) {
            throw new InvalidInputException("StaLtaTrigger");
        }
        this.stnID = BigEndian.readString(byArray, n + 0, 12);
        this.triggerID = BigEndian.readInt(byArray, n + 12);
        this.startTime = BigEndian.readDouble(byArray, n + 16);
        this.duration = BigEndian.readFloat(byArray, n + 24);
        this.ltaAtStart = BigEndian.readFloat(byArray, n + 28);
        this.ltaAtEnd = BigEndian.readFloat(byArray, n + 32);
        this.peakSta = BigEndian.readFloat(byArray, n + 36);
        this.maxPeakToPeak = BigEndian.readFloat(byArray, n + 40);
        this.timeToPeak = BigEndian.readFloat(byArray, n + 44);
        this.halfPeriod = BigEndian.readFloat(byArray, n + 48);
        this.phase = BigEndian.readInt(byArray, n + 52);
    }

    public String startTimeString() {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        long l = (long)(1000.0 * this.startTime);
        return dateFormat.format(new Date(l));
    }

    public String toString() {
        Format format = new Format("%.3f");
        String string = this.stnID + "-" + this.triggerID + ":" + this.phase + "  " + this.startTimeString() + "  " + format.form(this.duration);
        return string;
    }

    public int getDataLength() {
        return 56;
    }

    public String getStnID() {
        return this.stnID;
    }

    public int getTriggerID() {
        return this.triggerID;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getLtaAtStart() {
        return this.ltaAtStart;
    }

    public float getLtaAtEnd() {
        return this.ltaAtEnd;
    }

    public float getPeakSta() {
        return this.peakSta;
    }

    public float getMaxPeakToPeak() {
        return this.maxPeakToPeak;
    }

    public float getTimeToPeak() {
        return this.timeToPeak;
    }

    public float getHalfPeriod() {
        return this.halfPeriod;
    }

    public int getPhase() {
        return this.phase;
    }

    public float getPeakRatio() {
        float f = this.ltaAtStart > 0.0f ? this.ltaAtStart : 1.0f;
        return this.peakSta / f;
    }

    public String toFullString() {
        String string = " : ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStnID());
        stringBuffer.append(string + this.getTriggerID());
        stringBuffer.append(string + this.getStartTime());
        stringBuffer.append(string + this.getDuration());
        stringBuffer.append(string + this.getLtaAtStart());
        stringBuffer.append(string + this.getLtaAtEnd());
        stringBuffer.append(string + this.getPeakSta());
        stringBuffer.append(string + this.getMaxPeakToPeak());
        stringBuffer.append(string + this.getTimeToPeak());
        stringBuffer.append(string + this.getHalfPeriod());
        stringBuffer.append(string + this.getPhase());
        return stringBuffer.toString();
    }
}

