/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;
import java.util.Arrays;

public class TimeSyncPacket
extends NmxPacket {
    public static final int PACKET_TYPE = 4;
    public static final String SUBTYPE_NAME = "TimeSync";

    public TimeSyncPacket(byte[] byArray, int n) throws InvalidInputException {
        super(byArray, n);
    }

    public TimeSyncPacket(byte[] byArray, int n, int n2) throws InvalidInputException {
        super(byArray, n, n2);
    }

    public TimeSyncPacket(int n, double d, int n2) throws InvalidInputException {
        super(TimeSyncPacket.createTimeSync(n, d, n2), 0);
    }

    protected static byte[] createTimeSync(int n, double d, int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        byte[] byArray = new byte[17 * (n2 + 1)];
        Arrays.fill(byArray, (byte)0);
        byArray[0] = 4;
        long l = (long)(d * 10000.0 + 0.5);
        long l2 = l / 10000L;
        long l3 = l - 10000L * l2;
        LittleEndian.writeInt(byArray, 1, (int)l2);
        LittleEndian.writeShort(byArray, 5, (short)l3);
        LittleEndian.writeShort(byArray, 7, (short)n);
        byArray[17] = 9;
        return byArray;
    }

    public int getTimeFraction() {
        return LittleEndian.readShort(this.guts, 5);
    }

    public String getSubTypeName() {
        return SUBTYPE_NAME;
    }

    public String toString() {
        String string = this.getInstrumentName() + "-" + this.getSubTypeName() + " @ " + this.getPacketTimeString();
        return string;
    }
}

