/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.Log;
import ca.nanometrics.util.QueueImpl;
import ca.nanometrics.util.Runner;

public abstract class BufferedConsumer
extends Runner {
    private static final int TICK_INTERVAL = 1000;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int HOURS_PER_DAY = 24;
    private static final int READ_TIMEOUT = 200;
    private static final int WDG_LOOP_TIMEOUT = 60;
    protected QueueImpl objQ = new QueueImpl();
    private int maxQueue = 0;
    private int minQueue = 0;
    private int discardCount = 0;
    private boolean queueFull = false;

    public BufferedConsumer(String string) {
        super(string);
    }

    public BufferedConsumer(String string, int n) {
        super(string);
        this.maxQueue = n;
        this.minQueue = 8 * this.maxQueue / 10;
    }

    protected void append(Object object) {
        if (this.maxQueue == 0 || this.objQ.size() < this.maxQueue) {
            this.objQ.put(object);
        } else {
            if (!this.queueFull) {
                Log.report(this, 2, 3, "Queue full, data being discarded");
                this.queueFull = true;
                this.discardCount = 0;
            }
            ++this.discardCount;
        }
    }

    protected int getQsize() {
        return this.objQ.size();
    }

    protected abstract void process(Object var1);

    protected void open() {
    }

    protected void close() {
    }

    protected void tick() {
    }

    protected void onNewHour() {
    }

    protected void onNewDay() {
    }

    public final void run() {
        this.setWdgTimeout(60);
        this.open();
        long l = System.currentTimeMillis();
        long l2 = l / 1000L;
        int n = (int)(l / 3600000L);
        int n2 = n / 24;
        while (this.stayAlive) {
            int n3;
            long l3;
            this.setWdgTimeout(60);
            try {
                Object object = this.objQ.get(200);
                if (object != null) {
                    this.process(object);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                Log.report(this, 4, 4, "Exception in process(): " + exception);
            }
            if (this.queueFull && this.objQ.size() < this.minQueue) {
                this.queueFull = false;
                Log.report(this, 3, 3, "Discarded " + this.discardCount + " packets since Queue full");
            }
            if ((l3 = (l = System.currentTimeMillis()) / 1000L) == l2) continue;
            l2 = l3;
            try {
                this.tick();
            }
            catch (Exception exception) {
                Log.report(this, 4, 4, "Exception in tick(): " + exception);
            }
            int n4 = (int)(l / 3600000L);
            if (n4 != n) {
                n = n4;
                try {
                    this.onNewHour();
                }
                catch (Exception exception) {
                    Log.report(this, 4, 4, "Exception in onNewHour(): " + exception);
                }
            }
            if ((n3 = n4 / 24) == n2) continue;
            n2 = n3;
            try {
                this.onNewDay();
            }
            catch (Exception exception) {
                Log.report(this, 4, 4, "Exception in onNewDay(): " + exception);
            }
        }
        this.close();
    }
}

