/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.zip.CRC32;

public class ByteArrayHelper {
    private static final int BYTE_NOT_IN_ARRAY = -1;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ByteArrayHelper() {
    }

    public static byte[] createPaddedArray(int n, byte[] byArray, byte by) {
        byte[] byArray2 = new byte[n];
        int n2 = byArray.length;
        int n3 = n - n2;
        Arrays.fill(byArray2, 0, n3, by);
        System.arraycopy(byArray, 0, byArray2, n3, n2);
        return byArray2;
    }

    public static long getCRC32(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return cRC32.getValue();
    }

    public static String byteArrayToHexString(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            int n = 0;
            while (n < byArray.length) {
                stringBuffer = stringBuffer.append(ByteArrayHelper.byteToHex(byArray[n])).append(" ");
                ++n;
            }
        } else {
            int n = 0;
            while (n < byArray.length) {
                stringBuffer = stringBuffer.append(ByteArrayHelper.byteToHex(byArray[n]));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static byte[] subByteArrayFromStartEnd(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] subByteArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static char[] gethexDigitArray() {
        return hexDigit;
    }

    public static String byteToHex(byte by) {
        char[] cArray = new char[]{hexDigit[by >> 4 & 0xF], hexDigit[by & 0xF]};
        return new String(cArray);
    }

    public static byte[] hexToBytes(String string) throws NumberFormatException {
        BigInteger bigInteger;
        try {
            bigInteger = new BigInteger(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Input Not Hex!");
        }
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byArray = ByteArrayHelper.subByteArrayFromStartEnd(byArray, 1, byArray.length);
        }
        return byArray;
    }

    public static int unPaddedLength(byte[] byArray, byte by) {
        int n = 0;
        int n2 = 0;
        n2 = ByteArrayHelper.indexOf(byArray, by);
        if (n2 == -1) {
            return byArray.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            ++n;
            ++n3;
        }
        return n;
    }

    public static int indexOf(byte[] byArray, byte by) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == by) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

