/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

public class Float16Imp {
    static final int F32_SIGN_BITS = 1;
    static final int F32_EXPONENT_BITS = 8;
    static final int F32_MANTISSA_BITS = 23;
    static final int F32_SIGN_MASK = 1;
    static final int F32_EXPONENT_MASK = 255;
    static final int F32_MANTISSA_MASK = 0x7FFFFF;
    static final int F32_SIGN_SHIFT = 31;
    static final int F32_EXPONENT_SHIFT = 23;
    static final int F32_MANTISSA_SHIFT = 0;
    static final int F32_EXPONENT_BASE = 127;
    static final int F32_MANTISSA_BASE = 0x800000;
    static final int INTEGER_BITS = 32;
    static final int F16_SIGN_BITS = 1;
    static final int F16_EXPONENT_BITS = 6;
    static final int F16_MANTISSA_BITS = 9;
    static final int F16_MAGNITUDE_BITS = 15;
    static final int F16_SIGN_MASK = 1;
    static final int F16_EXPONENT_MASK = 63;
    static final int F16_MANTISSA_MASK = 511;
    static final int F16_MAGNITUDE_MASK = Short.MAX_VALUE;
    static final int F16_SIGN_SHIFT = 15;
    static final int F16_EXPONENT_SHIFT = 9;
    static final int F16_MANTISSA_SHIFT = 0;
    static final int F16_SIGN_TOGGLE = 32768;
    static final int F16_EXPONENT_BASE = 31;
    static final int F16_MANTISSA_BASE = 512;
    static final int F16_MANTISSA_OVERFLOW = 1024;
    static final int F16_PRODUCT_LIMIT = 524288;
    static final int F16_PRODUCT_ROUND = 256;
    static final String F16_OVERFLOW = "F16 Overflow";
    static final String F16_UNDERFLOW = "F16 Underflow";
    static final String F32_OVERFLOW = "F32 Overflow";
    static final String F32_UNDERFLOW = "F32 Underflow";

    static float bitsToFloat(int n) {
        if (Float16Imp.getMagnitudeOf(n) == 0) {
            return 0.0f;
        }
        return Float16Imp.makeFloat32(Float16Imp.getSignOf(n), Float16Imp.getExponentOf(n), Float16Imp.getMantissaOf(n) << 14);
    }

    static int floatToBits(float f) {
        if (f == 0.0f) {
            return 0;
        }
        int n = Float.floatToIntBits(f);
        int n2 = Float16Imp.getF32SignOf(n);
        int n3 = Float16Imp.getF32ExponentOf(n);
        int n4 = Float16Imp.getF32MantissaOf(n);
        n4 >>= 13;
        ++n4;
        if (((n4 >>= 1) & 0x400) != 0) {
            n4 >>= 1;
            ++n3;
        }
        return Float16Imp.makeFloat16(n2, n3, n4);
    }

    private static int getF32SignOf(int n) {
        return n >> 31 & 1;
    }

    private static int getF32ExponentOf(int n) {
        return (n >> 23 & 0xFF) - 127;
    }

    private static int getF32MantissaOf(int n) {
        return n >> 0 & 0x7FFFFF | 0x800000;
    }

    private static int getSignOf(int n) {
        return n >> 15 & 1;
    }

    private static int getExponentOf(int n) {
        return (n >> 9 & 0x3F) - 31;
    }

    private static int getMantissaOf(int n) {
        return n >> 0 & 0x1FF | 0x200;
    }

    private static int getMagnitudeOf(int n) {
        return n & Short.MAX_VALUE;
    }

    protected static void F16error(String string) {
    }

    private static int makeFloat16(int n, int n2, int n3) {
        if ((n2 += 31) <= 0) {
            Float16Imp.F16error(F16_UNDERFLOW);
            return 0;
        }
        if (n2 >= 63) {
            Float16Imp.F16error(F16_OVERFLOW);
            n2 = 62;
            n3 = 511;
        }
        int n4 = (n & 1) << 15 | (n2 & 0x3F) << 9 | (n3 & 0x1FF) << 0;
        return n4;
    }

    private static float makeFloat32(int n, int n2, int n3) {
        if ((n2 += 127) <= 0) {
            Float16Imp.F16error(F32_UNDERFLOW);
            return 0.0f;
        }
        if (n2 >= 255) {
            Float16Imp.F16error(F32_OVERFLOW);
            n2 = 254;
            n3 = 0x7FFFFF;
        }
        int n4 = (n & 1) << 31 | (n2 & 0xFF) << 23 | (n3 & 0x7FFFFF) << 0;
        return Float.intBitsToFloat(n4);
    }
}

