/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.Float16;

public class LittleEndian {
    public static int readInt(byte[] byArray, int n) {
        int n2 = (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }

    public static long readUInt(byte[] byArray, int n) {
        return (long)LittleEndian.readInt(byArray, n) & 0xFFFFFFFFL;
    }

    public static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 0] = (byte)(n2 & 0xFF);
    }

    public static short readShort(byte[] byArray, int n) {
        int n2 = (byArray[n + 1] & 0xFF) << 8 | byArray[n + 0] & 0xFF;
        return (short)n2;
    }

    public static int readUShort(byte[] byArray, int n) {
        return LittleEndian.readShort(byArray, n) & 0xFFFF;
    }

    public static void writeShort(byte[] byArray, int n, short s) {
        byArray[n + 1] = (byte)(s >> 8 & 0xFF);
        byArray[n + 0] = (byte)(s & 0xFF);
    }

    public static long readLong(byte[] byArray, int n) {
        long l = (long)(byArray[n + 7] & 0xFF) << 56 | (long)(byArray[n + 6] & 0xFF) << 48 | (long)(byArray[n + 5] & 0xFF) << 40 | (long)(byArray[n + 4] & 0xFF) << 32 | (long)(byArray[n + 3] & 0xFF) << 24 | (long)(byArray[n + 2] & 0xFF) << 16 | (long)(byArray[n + 1] & 0xFF) << 8 | (long)(byArray[n + 0] & 0xFF);
        return l;
    }

    public static void writeLong(byte[] byArray, int n, long l) {
        byArray[n + 7] = (byte)(l >> 56 & 0xFFL);
        byArray[n + 6] = (byte)(l >> 48 & 0xFFL);
        byArray[n + 5] = (byte)(l >> 40 & 0xFFL);
        byArray[n + 4] = (byte)(l >> 32 & 0xFFL);
        byArray[n + 3] = (byte)(l >> 24 & 0xFFL);
        byArray[n + 2] = (byte)(l >> 16 & 0xFFL);
        byArray[n + 1] = (byte)(l >> 8 & 0xFFL);
        byArray[n + 0] = (byte)(l & 0xFFL);
    }

    public static int readInt24(byte[] byArray, int n) {
        int n2 = byArray[n + 2] << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }

    public static int readUInt24(byte[] byArray, int n) {
        return LittleEndian.readInt24(byArray, n) & 0xFFFFFF;
    }

    public static void writeInt24(byte[] byArray, int n, int n2) {
        byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 0] = (byte)(n2 & 0xFF);
    }

    public static float readFloat(byte[] byArray, int n) {
        int n2 = LittleEndian.readInt(byArray, n);
        return Float.intBitsToFloat(n2);
    }

    public static void writeFloat(byte[] byArray, int n, float f) {
        int n2 = Float.floatToIntBits(f);
        LittleEndian.writeInt(byArray, n, n2);
    }

    public static double readDouble(byte[] byArray, int n) {
        long l = LittleEndian.readLong(byArray, n);
        return Double.longBitsToDouble(l);
    }

    public static void writeDouble(byte[] byArray, int n, double d) {
        long l = Double.doubleToLongBits(d);
        LittleEndian.writeLong(byArray, n, l);
    }

    public static double readFloat16(byte[] byArray, int n) {
        return Float16.bitsToFloat(LittleEndian.readUShort(byArray, n));
    }

    public static String readString(byte[] byArray, int n, int n2) {
        int n3 = 0;
        n3 = 0;
        while (n3 < n2) {
            if (byArray[n + n3] == 0) break;
            ++n3;
        }
        if (n3 > 0) {
            return new String(byArray, n, n3);
        }
        return new String();
    }

    public static void writeString(byte[] byArray, int n, String string, int n2) {
        byte[] byArray2 = string.getBytes();
        int n3 = Math.min(byArray2.length, n2 - 1);
        if (n3 > 0) {
            System.arraycopy(byArray2, 0, byArray, n, n3);
        }
        byArray[n + n3] = 0;
    }
}

