/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.Log;
import ca.nanometrics.util.WdgCounter;

public abstract class Runner
implements Runnable {
    final int WDG_STARTUP_TIMEOUT = 10;
    private String name;
    private Thread t = null;
    private int priority = 5;
    protected boolean stayAlive = false;
    private boolean isDaemon = false;
    private WdgCounter wdgCounter = new WdgCounter();

    public Runner(String string) {
        this.name = string;
    }

    public Runner() {
        String string = this.getClass().getName();
        this.name = string.substring(1 + string.lastIndexOf(46), string.length());
    }

    public void setDaemon(boolean bl) {
        this.isDaemon = bl;
    }

    public abstract void run();

    public boolean isAlive() {
        return this.t != null && this.t.isAlive();
    }

    public void setPriority(int n) {
        if (n > 10) {
            n = 10;
        }
        if (n < 1) {
            n = 1;
        }
        this.priority = n;
        this.setThreadPriority();
    }

    private synchronized void setThreadPriority() {
        block2: {
            if (this.t == null) break block2;
            try {
                this.t.setPriority(this.priority);
            }
            catch (Exception exception) {
                Log.report(this, 1, 3, "Cannot set thread priority");
            }
        }
    }

    public int getPriority() {
        if (this.t != null) {
            return this.t.getPriority();
        }
        return 0;
    }

    public void start() {
        if (this.isAlive()) {
            throw new IllegalThreadStateException("Runner");
        }
        this.setWdgTimeout(10);
        this.stayAlive = true;
        this.t = new Thread((Runnable)this, this.name);
        this.setThreadPriority();
        this.t.setDaemon(this.isDaemon);
        this.t.start();
    }

    public void stop() {
        this.stop(true);
    }

    public void stop(boolean bl) {
        if (this.isAlive()) {
            this.stayAlive = false;
            this.interrupt();
            if (bl) {
                try {
                    this.t.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.t = null;
    }

    public void restart() {
        this.stop(true);
        this.start();
    }

    public void interrupt() {
        if (this.t != null) {
            this.t.interrupt();
        }
    }

    public void join() throws InterruptedException {
        if (this.t != null) {
            this.t.join();
        }
    }

    public String getName() {
        return this.name;
    }

    protected void setWdgTimeout(int n) {
        this.wdgCounter.set(n);
    }

    public boolean isRunningOk() {
        return this.isAlive() && this.wdgCounter.test();
    }

    protected void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {}
    }
}

