/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.chart.beans.AxisRelationshipWrapper;
import com.klg.jclass.chart.beans.BeanTextParser;
import com.klg.jclass.chart.beans.JCChartBeanBundle;
import com.klg.jclass.chart.beans.MultiChart;
import com.klg.jclass.chart.beans.RadioEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AxisRelationshipEditor
extends RadioEditor
implements ItemListener,
ActionListener,
FocusListener {
    protected JLabel raxis_lb;
    protected JComboBox raxis_ch;
    protected JTextField constant_tf;
    protected JTextField multiplier_tf;
    protected String[] raxis_names;
    AxisRelationshipWrapper wrap = null;

    public AxisRelationshipEditor() {
        super(MultiChart.AXIS_RADIO_TITLE, MultiChart.AXIS_RADIO_NAMES);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.checkProperties(object);
    }

    public void checkProperties(Object object) {
        try {
            if (object == this.constant_tf) {
                this.setDoubleProperty(this.constant_tf.getText(), this.wrap.constant, this.radioSel, this.wrap.constant_def);
                this.switchValues(this.radioSel);
            } else if (object == this.multiplier_tf) {
                this.setDoubleProperty(this.multiplier_tf.getText(), this.wrap.multiplier, this.radioSel, this.wrap.multiplier_def);
                this.switchValues(this.radioSel);
            } else if (object == this.raxis_ch) {
                int n = this.raxis_ch.getSelectedIndex();
                this.wrap.raxis[this.radioSel] = n == this.raxis_names.length ? -1 : n;
                this.support.firePropertyChange("", null, null);
            }
        }
        catch (Exception exception) {}
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        this.checkProperties(object);
    }

    public String getAsText() {
        if (this.wrap != null) {
            return this.wrap.toString();
        }
        return null;
    }

    public String getJavaInitializationString() {
        return "new com.klg.jclass.chart.beans.AxisRelationshipWrapper(" + this.wrap + ")";
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(dimension.width, 400);
        dimension.height += 250;
        return dimension;
    }

    public Object getValue() {
        return this.wrap;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object instanceof JComboBox && itemEvent.getStateChange() != 2) {
            this.checkProperties(object);
        }
    }

    protected JPanel makePropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key229")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.raxis_ch = new JComboBox();
        this.setEnumArrays();
        int n = 0;
        while (n < this.raxis_names.length) {
            this.raxis_ch.addItem(this.raxis_names[n]);
            ++n;
        }
        this.raxis_ch.addItem(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key215"));
        this.raxis_lb = new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key230"));
        JLabel jLabel = new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key231"));
        JLabel jLabel2 = new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key232"));
        this.multiplier_tf = new JTextField(5);
        this.constant_tf = new JTextField(5);
        jPanel.add((Component)this.raxis_lb, gridBagConstraints);
        jPanel.add((Component)this.raxis_ch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)this.multiplier_tf, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel.add((Component)this.constant_tf, gridBagConstraints);
        this.add("Center", jPanel);
        this.raxis_ch.addItemListener(this);
        this.multiplier_tf.addActionListener(this);
        this.multiplier_tf.addFocusListener(this);
        this.constant_tf.addActionListener(this);
        this.constant_tf.addFocusListener(this);
        return jPanel;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Vector vector = BeanTextParser.parse(string);
        if (vector.size() != 3) {
            throw new IllegalArgumentException();
        }
        AxisRelationshipWrapper axisRelationshipWrapper = null;
        try {
            axisRelationshipWrapper = new AxisRelationshipWrapper((String)vector.elementAt(0), (String)vector.elementAt(1), (String)vector.elementAt(2));
            this.setValue(axisRelationshipWrapper);
            this.support.firePropertyChange("", null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    protected void setEnumArrays() {
        this.raxis_names = new String[MultiChart.AXIS_RADIO_NAMES.length];
        System.arraycopy(MultiChart.AXIS_RADIO_NAMES, 0, this.raxis_names, 0, MultiChart.AXIS_RADIO_NAMES.length);
    }

    public void setRAxis(int[] nArray, int n, String[] stringArray, JComboBox jComboBox) {
        if (this.wrap.raxis[n] == -1) {
            if (jComboBox.getSelectedIndex() != jComboBox.getItemCount() - 1) {
                jComboBox.setSelectedIndex(jComboBox.getItemCount() - 1);
            }
        } else {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (MultiChart.AXIS_RADIO_NAMES[nArray[n]].equals(stringArray[n2]) && jComboBox.getSelectedIndex() != n2) {
                    jComboBox.setSelectedIndex(n2);
                }
                ++n2;
            }
        }
    }

    public void setValue(Object object) {
        if (object != null) {
            try {
                this.wrap = (AxisRelationshipWrapper)object;
            }
            catch (ClassCastException classCastException) {}
        }
        if (this.wrap == null) {
            this.wrap = new AxisRelationshipWrapper(this.numOfRadios);
        }
        this.switchValues(this.radioSel);
    }

    protected void switchValues(int n) {
        if (n < 0 || this.wrap == null) {
            return;
        }
        this.setRAxis(this.wrap.raxis, n, this.raxis_names, this.raxis_ch);
        this.multiplier_tf.setText(String.valueOf(this.wrap.multiplier[n]));
        this.constant_tf.setText(String.valueOf(this.wrap.constant[n]));
        this.validate();
    }
}

