/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.progress.JCProgressCancelledEvent;
import com.klg.jclass.util.progress.JCProgressCancelledListener;
import com.klg.jclass.util.progress.JCProgressEvent;
import com.klg.jclass.util.progress.JCProgressListener;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class JCProgressHelper {
    protected Component parent;
    protected String staticMessage;
    protected String dynamicMessage = " ";
    protected String dialogTitle = "Progress...";
    protected String cancelString = "Cancel";
    protected JProgressBar progressbar;
    protected JDialog dialog;
    protected String staticMessageLabel;
    protected JOptionPane optionPane;
    protected JLabel dynamicMessageLabel;
    protected boolean isModal;
    protected boolean isDismissable;
    protected boolean showDynamicMessage;
    protected int max;
    protected int min;
    protected int value;
    protected long decideTime = 500L;
    protected long popupTime = 2000L;
    protected long startTime;
    protected boolean popupInitiated = false;
    protected boolean progressComplete = false;
    protected boolean firstPass = true;
    protected JCListenerList progressCancelledListeners = null;

    public JCProgressHelper(Component component) {
        this(component, null, 0, 0, true, false, false);
    }

    public JCProgressHelper(Component component, String string, int n, int n2) {
        this(component, string, n, n2, true, false, false);
    }

    public JCProgressHelper(Component component, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.parent = component;
        this.staticMessage = string;
        this.max = n2;
        this.min = n;
        this.value = n;
        this.showDynamicMessage = bl;
        this.isModal = bl2;
        this.isDismissable = bl3;
    }

    public void addProgressCancelledListener(JCProgressCancelledListener jCProgressCancelledListener) {
        this.progressCancelledListeners = JCListenerList.add(this.progressCancelledListeners, jCProgressCancelledListener);
    }

    public void completeProgress() {
        this.progressComplete = true;
        this.popupInitiated = false;
        Runnable runnable = new Runnable(){

            public void run() {
                if (JCProgressHelper.this.dialog != null) {
                    JCProgressHelper.this.optionPane.setInputValue(new Integer(0));
                    JCProgressHelper.this.dialog = null;
                    JCProgressHelper.this.progressbar = null;
                    JCProgressHelper.this.dynamicMessageLabel = null;
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public JCProgressListener createProgressListener() {
        return new ProgressListener();
    }

    protected void fireUserCancelledProgressEvent(JCProgressCancelledEvent jCProgressCancelledEvent) {
        Enumeration enumeration = JCListenerList.elements(this.progressCancelledListeners);
        while (enumeration.hasMoreElements()) {
            JCProgressCancelledListener jCProgressCancelledListener = (JCProgressCancelledListener)enumeration.nextElement();
            jCProgressCancelledListener.userCancelledProgress(jCProgressCancelledEvent);
        }
    }

    public String getCancelString() {
        return this.cancelString;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public boolean isOkayToContinue() {
        if (this.optionPane == null) {
            return true;
        }
        Object object = this.optionPane.getValue();
        return object == JOptionPane.UNINITIALIZED_VALUE;
    }

    protected void popupDialog() {
        this.popupInitiated = true;
        if (this.progressComplete) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                JCProgressHelper jCProgressHelper = JCProgressHelper.this;
                synchronized (jCProgressHelper) {
                    if (JCProgressHelper.this.progressComplete) {
                        Object var2_2 = null;
                        return;
                    }
                    int n = 1;
                    if (JCProgressHelper.this.max != -1) {
                        JCProgressHelper.this.progressbar = new JProgressBar();
                        JCProgressHelper.this.progressbar.setMaximum(JCProgressHelper.this.max);
                        JCProgressHelper.this.progressbar.setMinimum(JCProgressHelper.this.min);
                        JCProgressHelper.this.progressbar.setValue(JCProgressHelper.this.min);
                        ++n;
                    }
                    if (JCProgressHelper.this.showDynamicMessage) {
                        JCProgressHelper.this.dynamicMessageLabel = new JLabel(" ");
                        ++n;
                    }
                    Object[] objectArray = new Object[n];
                    n = 0;
                    objectArray[n++] = JCProgressHelper.this.staticMessage;
                    if (JCProgressHelper.this.dynamicMessageLabel != null) {
                        objectArray[n++] = JCProgressHelper.this.dynamicMessageLabel;
                    }
                    if (JCProgressHelper.this.progressbar != null) {
                        objectArray[n++] = JCProgressHelper.this.progressbar;
                    }
                    JCProgressHelper.this.optionPane = new ProgressPane(objectArray, JCProgressHelper.this.cancelString);
                    JCProgressHelper.this.dialog = JCProgressHelper.this.optionPane.createDialog(JCProgressHelper.this.parent, JCProgressHelper.this.dialogTitle);
                    JCProgressHelper.this.dialog.setModal(JCProgressHelper.this.isModal);
                    JCProgressHelper.this.optionPane.addPropertyChangeListener(new PropertyChangeListener(JCProgressHelper.this){
                        private final /* synthetic */ JCProgressHelper this$0;
                        boolean once;
                        {
                            this.this$0 = jCProgressHelper;
                            this.once = true;
                        }

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (this.once) {
                                this.this$0.fireUserCancelledProgressEvent(new JCProgressCancelledEvent(propertyChangeEvent.getSource()));
                            }
                            this.once = false;
                        }
                    });
                    JCProgressHelper.this.dialog.show();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeProgressCancelledListener(JCProgressCancelledListener jCProgressCancelledListener) {
        this.progressCancelledListeners = JCListenerList.remove(this.progressCancelledListeners, jCProgressCancelledListener);
    }

    public void setCancelString(String string) {
        this.cancelString = string;
    }

    public void setDialogTitle(String string) {
        this.dialogTitle = string;
    }

    public void setDynamicMessage(String string) {
        if (this.dynamicMessage == string) {
            return;
        }
        this.dynamicMessage = string == null ? "" : string;
        if (this.dynamicMessageLabel == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (JCProgressHelper.this.dynamicMessageLabel != null) {
                    JCProgressHelper.this.dynamicMessageLabel.setText(JCProgressHelper.this.dynamicMessage);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setMaximum(int n) {
        this.max = n;
        Runnable runnable = new Runnable(){

            public void run() {
                if (JCProgressHelper.this.progressbar != null) {
                    JCProgressHelper.this.progressbar.setMaximum(JCProgressHelper.this.max);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setMinimum(int n) {
        this.min = n;
        Runnable runnable = new Runnable(){

            public void run() {
                if (JCProgressHelper.this.progressbar != null) {
                    JCProgressHelper.this.progressbar.setMinimum(JCProgressHelper.this.min);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setRange(int n, int n2) {
        this.min = n;
        this.max = n2;
        Runnable runnable = new Runnable(){

            public void run() {
                if (JCProgressHelper.this.progressbar != null) {
                    JCProgressHelper.this.progressbar.setMinimum(JCProgressHelper.this.min);
                    JCProgressHelper.this.progressbar.setMaximum(JCProgressHelper.this.max);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setStaticMessage(String string) {
        this.staticMessage = string;
    }

    public void setTimeToDecideToPopup(long l) {
        this.decideTime = l;
    }

    public void setTimeToPopup(long l) {
        this.popupTime = l;
    }

    public void startProgress() {
        if (!this.progressComplete && !this.firstPass) {
            this.completeProgress();
        }
        this.progressComplete = false;
        this.popupInitiated = false;
        this.startTime = System.currentTimeMillis();
        Runnable runnable = new Runnable(){

            public void run() {
                boolean bl = false;
                if (JCProgressHelper.this.popupTime > 0L) {
                    try {
                        Thread.sleep(JCProgressHelper.this.popupTime);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
                if (!(bl || JCProgressHelper.this.popupInitiated || JCProgressHelper.this.progressComplete)) {
                    JCProgressHelper.this.popupDialog();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateProgress(int n) {
        this.value = n;
        if (!this.popupInitiated) {
            long l = System.currentTimeMillis() - this.startTime;
            if (l < this.decideTime) return;
            long l2 = Integer.MAX_VALUE;
            if (this.value != this.min) {
                l2 = l / (long)(this.value - this.min) * (long)(this.max - this.min);
            }
            if (l2 <= this.popupTime) return;
            this.popupDialog();
        }
        Runnable runnable = new Runnable(){
            int val;
            {
                this.val = JCProgressHelper.this.value;
            }

            public void run() {
                if (JCProgressHelper.this.progressbar != null) {
                    JCProgressHelper.this.progressbar.setValue(this.val);
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    class ProgressPane
    extends JOptionPane {
        ProgressPane(Object object, String string) {
            super(object, 1, 0, null, new Object[]{string}, null);
            this.setUI(new ProgressPaneUI());
        }

        public int getMaxCharactersPerLineCount() {
            return 60;
        }
    }

    class ProgressPaneUI
    extends BasicOptionPaneUI {
        ProgressPaneUI() {
        }

        protected Object[] getButtons() {
            if (JCProgressHelper.this.isDismissable) {
                return super.getButtons();
            }
            return null;
        }
    }

    class ProgressListener
    implements JCProgressListener {
        ProgressListener() {
        }

        public void processingBegin(JCProgressEvent jCProgressEvent) {
            JCProgressHelper.this.setStaticMessage(jCProgressEvent.getProcessName());
            JCProgressHelper.this.setMinimum(0);
            JCProgressHelper.this.setMaximum(jCProgressEvent.getUnitCount());
            JCProgressHelper.this.startProgress();
            JCDebug.println("JCProgressHelper", "BEGIN " + jCProgressEvent.getProcessName());
        }

        public void processingEnd(JCProgressEvent jCProgressEvent) {
            JCDebug.println("JCProgressHelper", "Completed " + jCProgressEvent.getProcessName());
            JCProgressHelper.this.completeProgress();
        }

        public void processingError(JCProgressEvent jCProgressEvent) {
            JCDebug.println("JCProgressHelper", "Error in " + jCProgressEvent.getProcessName());
        }

        public void processingUnit(JCProgressEvent jCProgressEvent) {
            if (!JCProgressHelper.this.isOkayToContinue()) {
                jCProgressEvent.setAbort(true);
            }
            JCProgressHelper.this.setDynamicMessage(jCProgressEvent.getUnitName());
            JCProgressHelper.this.updateProgress(jCProgressEvent.getCurrentUnit());
            JCDebug.println("JCProgressHelper", String.valueOf(jCProgressEvent.getCurrentUnit()) + " of " + jCProgressEvent.getUnitCount());
        }
    }
}

