/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.alert.Alert;
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.naqs.stndb.ChannelConfig;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.packet.DoDRequestPacket;
import ca.nanometrics.packet.HrdCommandConnector;
import ca.nanometrics.packet.HrdCommandHandler;
import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketDistributor;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.util.BufferedConsumer;
import ca.nanometrics.util.Log;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class ArchiveManager
extends BufferedConsumer
implements NmxPacketHandler,
HrdCommandHandler,
NmxPacketSource {
    public static final int OPEN_TIMEOUT = 30;
    private ArchiveManagerConfig cfg;
    private StationDatabase stndb;
    private Vector channels;
    private RbfTable rbftable;
    private RingBuffer[] rbfs;
    private HrdCommandConnector connector;
    private PacketRxMonitor rxMonitor;
    NmxPacketDistributor distributor = new NmxPacketDistributor();

    public ArchiveManager(ArchiveManagerConfig config, StationDatabase database) {
        super("ArchiveManager", 1000);
        this.cfg = config;
        this.stndb = database;
        this.connector = new HrdCommandConnector(null);
        this.rxMonitor = new PacketRxMonitor(this.stndb);
    }

    public void update(ArchiveManagerConfig newConfig, UpdateMode mode, UpdateResult result) {
    }

    protected void open() {
        this.setPriority(10);
        Log.report(this, 5, 2, "starting with priority " + this.getPriority());
        this.channels = this.stndb.getChannels();
        this.rbftable = new RbfTable();
        RbfNameMap rbfmap = new RbfNameMap();
        int tryOpen = 0;
        Enumeration e = this.channels.elements();
        while (e.hasMoreElements()) {
            this.setWdgTimeout(30);
            ChannelConfig chan = (ChannelConfig)e.nextElement();
            try {
                ++tryOpen;
                RingBuffer rbf = new RingBuffer(chan, this.distributor, this.connector);
                this.rbftable.put(chan.getKey(), rbf);
                rbfmap.put(rbf);
            }
            catch (IOException exc) {
                Log.report(this, 6, 3, exc.getMessage());
            }
        }
        Log.report(this, 7, 2, "opened " + this.rbftable.size() + " of " + tryOpen + " ringbuffers.");
        if (this.rbftable.size() != tryOpen) {
            int numFail = tryOpen - this.rbftable.size();
            Alert.report("RbfOpenFail", numFail, "File open failed on %1 / %2 ringbuffers.  See Naqs log.", "/" + numFail + "/" + tryOpen);
        }
        this.rbfs = new RingBuffer[rbfmap.size()];
        int ix = 0;
        Iterator it = rbfmap.iterator();
        while (it.hasNext()) {
            String channelName = (String)it.next();
            this.rbfs[ix++] = rbfmap.get(channelName);
        }
    }

    protected void close() {
        Log.report(this, 8, 2, "closing all ringbuffers...");
        int ix = 0;
        int nx = this.rbfs.length;
        while (ix < nx) {
            RingBuffer rbf = this.rbfs[ix];
            rbf.close();
            ++ix;
        }
    }

    protected void process(Object obj) {
        NmxPacket packet = (NmxPacket)obj;
        this.rxMonitor.processPacket(packet);
        RingBuffer rbf = this.rbftable.get(packet.getKey());
        if (rbf != null) {
            rbf.put(packet);
        }
    }

    protected void tick() {
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        int ix = 0;
        int nx = this.rbfs.length;
        while (ix < nx) {
            this.rbfs[ix].tick(currentTime);
            ++ix;
        }
        this.rxMonitor.test();
    }

    public void put(NmxPacket packet) {
        this.append(packet);
    }

    public void setReTxHandler(HrdCommandHandler handler) {
        this.connector.setHandler(handler);
    }

    public int requestPackets(int key, int first, int last, NmxPacketHandler dest) {
        RingBuffer rbf = this.rbftable.get(key);
        if (rbf != null) {
            return rbf.requestPackets(key, first, last, dest);
        }
        return 0;
    }

    public void addNmxpSubscriber(NmxPacketHandler subscriber) {
        this.distributor.addSubscriber(subscriber);
    }

    public void removeNmxpSubscriber(NmxPacketHandler subscriber) {
        this.distributor.removeSubscriber(subscriber);
    }

    public synchronized void reportStatus(String hint) {
        int ix = 0;
        int nx = this.rbfs.length;
        while (ix < nx) {
            RingBuffer rbf = this.rbfs[ix];
            String channelName = rbf.getDottedName();
            if (hint.equals("ALL") || hint.equals("CHANNELS") || channelName.startsWith(hint) || channelName.endsWith(hint)) {
                rbf.reportStatus();
            }
            ++ix;
        }
    }

    public synchronized void resetStatus(String channel) {
        int channelsFound = 0;
        int ix = 0;
        int nx = this.rbfs.length;
        while (ix < nx) {
            RingBuffer rbf = this.rbfs[ix];
            String channelName = rbf.getDottedName();
            if (channel.equals("ALL") || channel.equals("CHANNELS") || channelName.startsWith(channel) || channelName.endsWith(channel)) {
                rbf.resetStatus();
                ++channelsFound;
            }
            ++ix;
        }
        Log.report(this, 9, 2, "Reset " + channelsFound + " channels matching " + channel);
    }

    public void monitorChannels(String channel, int interval) {
        int channelsFound = 0;
        int ix = 0;
        int nx = this.rbfs.length;
        while (ix < nx) {
            RingBuffer rbf = this.rbfs[ix];
            String channelName = rbf.getDottedName();
            if (channel.equals("ALL") || channel.equals("CHANNELS") || channelName.startsWith(channel) || channelName.endsWith(channel)) {
                rbf.setMonitoringInterval(interval);
                ++channelsFound;
            }
            ++ix;
        }
        if (channelsFound == 0) {
            Log.report(this, 9, 2, "Monitor: no channels matching " + channel);
        } else if (interval > 0) {
            Log.report(this, 9, 2, "Monitoring " + channel + " every " + interval + " seconds.");
        } else {
            Log.report(this, 9, 2, "Monitoring off on channels " + channel);
        }
    }

    public void monitorChannels(String channel, String sInterval) {
        int interval = -1;
        if (sInterval.equals("ON")) {
            interval = 60;
        } else if (sInterval.equals("OFF")) {
            interval = 0;
        } else {
            try {
                interval = Integer.parseInt(sInterval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (interval >= 0) {
            this.monitorChannels(channel, interval);
        } else {
            Log.report(this, 9, 2, "Invalid monitoring interval: " + sInterval);
        }
    }

    public void put(HrdCommandPacket packet) {
        if (!(packet instanceof DoDRequestPacket)) {
            Log.report(this, 9, 4, "Packet: " + packet.toString() + " is not a Data on Demand request.");
            return;
        }
        Log.report(this, 9, 0, "Recieved HrdCommandPacket: " + packet.toString());
        DoDRequestPacket dod = (DoDRequestPacket)packet;
        int i = 0;
        while (i < this.rbfs.length) {
            this.rbfs[i].put(dod);
            ++i;
        }
    }
}

