/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationEventMessage;
import ca.nanometrics.msg.MsgSubscriber;
import ca.nanometrics.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CalibrationEventDistributor
implements CalibrationEventHandler {
    private Map subscribers = new HashMap();

    public void addSubscriber(MsgSubscriber subscriber, String identifier) {
        this.subscribers.put(identifier, subscriber);
    }

    public void removeSubscriber(MsgSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    public void removeSubscribers(String calibrationIdentifier) {
        Iterator iter = this.getIdentifierIterator();
        while (iter.hasNext()) {
            String identifier = (String)iter.next();
            if (!identifier.equals(calibrationIdentifier)) continue;
            iter.remove();
        }
    }

    public void put(CalibrationEventMessage item) {
        Iterator iter = this.getEntryIterator();
        while (iter.hasNext()) {
            Map.Entry me = (Map.Entry)iter.next();
            String identifier = (String)me.getKey();
            if (!identifier.equals(item.getIdentifier())) continue;
            MsgSubscriber dph = (MsgSubscriber)me.getValue();
            dph.send(item);
            Log.report(this, 2, 0, "Distributing calibration event message to " + dph);
        }
    }

    public Iterator getIdentifierIterator() {
        Set keyset = this.subscribers.keySet();
        return keyset.iterator();
    }

    public Iterator getEntryIterator() {
        Set entrySet = this.subscribers.entrySet();
        return entrySet.iterator();
    }
}

