/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationEventMessage;
import ca.nanometrics.msg.CalibrationList;
import ca.nanometrics.msg.MsgSubscriber;
import ca.nanometrics.util.BufferedConsumer;
import ca.nanometrics.util.Log;
import java.util.Date;

public class CalibrationTracker
extends BufferedConsumer {
    private static final int MIN_WAIT_SECS = 300;
    private CalibrationList currentCalibrations = new CalibrationList();
    private CalibrationEventDistributor distributor = new CalibrationEventDistributor();

    public CalibrationTracker() {
        super("CalibrationTracker", 1000);
    }

    public boolean isInstrumentAvailable(int instrumentID) {
        this.currentCalibrations.removeExpired();
        return !this.currentCalibrations.contains(instrumentID);
    }

    public void put(CalibrationEventMessage cem) {
        Log.report(this, 1, 0, "Appending calibration event");
        this.append(cem);
    }

    public void addCalibration(int instrumentID, String identifier, double duration, MsgSubscriber subscriber) {
        Date now = new Date();
        Date expiryDate = new Date((long)((double)now.getTime() + (duration + 300.0) * 1000.0));
        this.currentCalibrations.add(instrumentID, "NaqsServer request", identifier, expiryDate);
        this.distributor.addSubscriber(subscriber, identifier);
    }

    public void cancelCalibration(String identifier) {
        CalibrationEventMessage cancelCEM = this.currentCalibrations.getCalibrationEventMessage(identifier);
        cancelCEM.setMsg("Calibration aborted.");
        this.stopCalibration(cancelCEM);
    }

    public void stopCalibration(CalibrationEventMessage calEventMsg) {
        this.currentCalibrations.remove(calEventMsg.getIdentifier());
        this.distributor.put(calEventMsg);
        this.distributor.removeSubscribers(calEventMsg.getIdentifier());
    }

    public void sendCurrentCalibrations(MsgSubscriber subscriber) {
        subscriber.send(this.currentCalibrations);
    }

    public CalibrationList getCurrentCalibrations() {
        return this.currentCalibrations;
    }

    public String lookupIdentifier(int instrumentID) {
        CalibrationEventMessage cem = this.currentCalibrations.getMessage(instrumentID);
        if (cem != null) {
            return cem.getIdentifier();
        }
        return null;
    }

    protected void process(Object obj) {
        CalibrationEventMessage calEventMsg = (CalibrationEventMessage)obj;
        Log.report(this, 1, 0, "Processing calibration event message");
        if (calEventMsg.isStartMessage()) {
            Date expiry = this.currentCalibrations.getExpiry(calEventMsg);
            this.currentCalibrations.add(calEventMsg, expiry);
            this.distributor.put(calEventMsg);
        } else if (calEventMsg.isStopMessage() || calEventMsg.isRejectionMessage()) {
            this.stopCalibration(calEventMsg);
        }
    }
}

