/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationEventMessage;
import ca.nanometrics.msg.CalibrationList;
import ca.nanometrics.msg.MsgSubscriber;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.PrintLog;
import java.net.InetAddress;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CalibrationTrackerTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public CalibrationTrackerTest(String name) {
        super(name);
    }

    public static Test Suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("CalibrationTrackerTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() {
        PrintLog log = new PrintLog();
        Log.installLog(log);
        log.setVerbosity(0);
    }

    public void testConstructor() throws Exception {
        Log.report((Object)this, 1, 0, "Testing Constructor");
        CalibrationTrackerTest.assertNotNull((String)"null CalibrationTracker construct", (Object)new CalibrationTracker());
    }

    public void testAddGetCalibration() throws Exception {
        Log.report((Object)this, 1, 0, "Testing Add/Get calibration");
        CalibrationTracker ct = new CalibrationTracker();
        TestSubscriber subscriber = new TestSubscriber();
        ct.addCalibration(1234, "testAddCalibration", 40.2, subscriber);
        ct.sendCurrentCalibrations(subscriber);
        CalibrationTrackerTest.assertNotNull((String)"Send current calibrations failed", (Object)subscriber.sentPackable);
        CalibrationTrackerTest.assertTrue((String)"Send current calibrations did not sent a CalibrationList", (boolean)(subscriber.sentPackable instanceof CalibrationList));
        CalibrationList cl = (CalibrationList)subscriber.sentPackable;
        CalibrationTrackerTest.assertTrue((boolean)cl.contains("testAddCalibration"));
        cl = ct.getCurrentCalibrations();
        CalibrationTrackerTest.assertTrue((boolean)cl.contains("testAddCalibration"));
        CalibrationTrackerTest.assertEquals((int)1, (int)cl.size());
    }

    public void testIsInstrumentAvailable() throws Exception {
        Log.report((Object)this, 1, 0, "Testing IsInstrumentAvailable");
        CalibrationTracker ct = new CalibrationTracker();
        CalibrationTrackerTest.assertTrue((String)"IsInstrumentAvailable should be available before adding", (boolean)ct.isInstrumentAvailable(1234));
        ct.addCalibration(1234, "testAddCalibration", 40.5, null);
        CalibrationTrackerTest.assertTrue((String)"IsInstrumentAvailable should be not be available after adding", (!ct.isInstrumentAvailable(1234) ? 1 : 0) != 0);
    }

    public void testPut() throws Exception {
        Log.report((Object)this, 1, 0, "Testing put");
        CalibrationTracker ct = new CalibrationTracker();
        CalibrationEventMessage cem = new CalibrationEventMessage(1234, "Calibration started.", "testPut");
        ct.put(cem);
        this.waitForPut();
        CalibrationTrackerTest.assertTrue((String)"Calibration start should have had effect", (!ct.isInstrumentAvailable(1234) ? 1 : 0) != 0);
        CalibrationEventMessage finishCem = new CalibrationEventMessage(1234, "Calibration finished.", "testPut");
        ct.put(finishCem);
        this.waitForPut();
        CalibrationTrackerTest.assertTrue((String)"Calibration stop should have made instrument available", (boolean)ct.isInstrumentAvailable(1234));
    }

    public void testSubscribeInterface() throws Exception {
        Log.report((Object)this, 1, 0, "Testing subscriber interface");
        CalibrationTracker ct = new CalibrationTracker();
        TestSubscriber subscriber = new TestSubscriber();
        ct.addCalibration(1234, "testPut", 40.2, subscriber);
        ct.put(new CalibrationEventMessage(1234, "Calibration started.", "testPut"));
        this.waitForPut();
        CalibrationTrackerTest.assertNotNull((String)"Send of event to subscriber failed", (Object)subscriber.testEvent);
        CalibrationTrackerTest.assertEquals((String)"Send of event to subscriber shows incorrect identifier", (String)"testPut", (String)subscriber.testEvent.getIdentifier());
        ct.put(new CalibrationEventMessage(1234, "Calibration finished.", "testPut"));
        this.waitForPut();
        CalibrationTrackerTest.assertTrue((String)"Send of finish event to subscriber", (boolean)subscriber.testEvent.getMsg().matches(".*finished.*"));
        ct.put(new CalibrationEventMessage(1234, "Calibration started.", "testPut"));
        this.waitForPut();
        CalibrationTrackerTest.assertTrue((String)"Send of event to subscriber after subscription removal", (boolean)subscriber.testEvent.getMsg().matches(".*finished.*"));
    }

    private synchronized void waitForPut() {
        try {
            ((Object)((Object)this)).wait(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class TestSubscriber
    implements MsgSubscriber {
        private Packable sentPackable = null;
        private CalibrationEventMessage testEvent = null;

        private TestSubscriber() {
        }

        public int getPort() {
            return 0;
        }

        public InetAddress getAddress() {
            return null;
        }

        public boolean send(Packable p) {
            this.sentPackable = p;
            this.notifyOfSendReceive();
            Log.report(this, 1, 0, "Received packet (CalibrationList)");
            if (p instanceof CalibrationEventMessage) {
                this.testEvent = (CalibrationEventMessage)p;
                Log.report(this, 1, 0, "Subscriber received CalibrationEventMessage");
            }
            return true;
        }

        public void flush() {
        }

        private synchronized void notifyOfSendReceive() {
            this.notify();
        }
    }
}

