/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.Serialisable;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.StringParam;
import ca.nanometrics.naqs.config.StringRange;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.util.SimpleParser;
import java.io.IOException;

public class CalibratorConfig
implements Serialisable {
    private StringRange namelen = new StringRange(3, 12);
    private StringParam password = new StringParam("CalPW", "none", 18, this.namelen);

    public void update(CalibratorConfig newConfig, UpdateMode mode, UpdateResult result) {
        try {
            this.password.putValue(newConfig.getPassword(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        strm.serialiseObject(this.namelen);
        this.password.saveGuts(strm);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        strm.deserialiseObject(this.namelen);
        this.password.restoreGuts(strm);
    }

    public void load(SimpleParser input) throws IOException {
        input.getHeader("Calibrator");
        this.setPassword(input.readString("Password"));
    }

    public String getPassword() {
        return this.password.getValue();
    }

    public void setPassword(String name) {
        this.password.putValue(name);
    }
}

