/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationCommand;
import ca.nanometrics.msg.CalibrationEventMessage;
import ca.nanometrics.msg.CalibrationResult;
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.CommandResult;
import ca.nanometrics.msg.MassCenterCommand;
import ca.nanometrics.msg.MassCenterResult;
import ca.nanometrics.msg.MsgSubscriber;
import ca.nanometrics.msg.SensorCommandRequest;
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.naqs.stndb.SimpleStationDatabase;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.HrdCalPacket;
import ca.nanometrics.packet.HrdCommandConnector;
import ca.nanometrics.packet.HrdCommandHandler;
import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.packet.SWCalibrationCommandPacket;
import ca.nanometrics.packet.test.NmxPacketMaker;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.PrintLog;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CalibratorTest
extends TestCase {
    SimpleStationDatabase stndb;
    HrdCommandManager calibrator;
    SimpleCommandHandler sch;
    SimpleSubscriber subscriber;
    static /* synthetic */ Class class$0;

    public CalibratorTest(String name) {
        super(name);
    }

    public static Test Suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("CalibratorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() {
        PrintLog log = new PrintLog();
        Log.installLog(log);
        log.setVerbosity(0);
        try {
            this.stndb = new SimpleStationDatabase("Naqs.stn");
        }
        catch (IOException e) {
            CalibratorTest.assertTrue((String)"stndb not created", (boolean)false);
        }
        this.calibrator = new HrdCommandManager(new CalibratorConfig(), this.stndb);
        this.sch = new SimpleCommandHandler();
        this.calibrator.setHandler(new HrdCommandConnector(this.sch));
        this.subscriber = new SimpleSubscriber();
    }

    public void testConstructor() throws Exception {
        CalibratorTest.assertNotNull((String)"null calibrator on construct", (Object)new HrdCommandManager(new CalibratorConfig(), null));
    }

    public void testUpdate() throws Exception {
        Log.report((Object)this, 4, 2, "Trying password update");
        CalibratorConfig cc = new CalibratorConfig();
        cc.setPassword("calpass");
        UpdateResult ur = new UpdateResult();
        this.calibrator.update(cc, new UpdateMode(1, 18), ur);
        CalibratorTest.assertTrue((String)("Update did not occur: " + ur.getResult()), (boolean)ur.isSuccess());
    }

    public void testCalibrateSensorCommandRequest() throws Exception {
        Log.report((Object)this, 4, 2, "Trying calibrate (SensorCommandRequest) ");
        Log.report((Object)this, 4, 2, "Trying calibrate (SensorCommandRequest) ");
        ChannelList chanList = this.stndb.getChannelList();
        String instrument = "STN01";
        String[] channels = new String[]{"BHZ"};
        int instrumentID = ChannelKey.getIDOf(chanList.getKeyOf(String.valueOf(instrument) + "." + channels[0]));
        SWCalibrationCommandPacket ccp = new SWCalibrationCommandPacket((int)new Date().getTime() / 1000, instrumentID, 1, 1, 1, 0, 4.0f, 0.0f, 0.0f, 0.0f, 120.0f, "myID", 3.0f);
        SensorCommandRequest scr = new SensorCommandRequest("myID", "mhowellj", instrument, channels, ccp.toBytes());
        this.calibrator.handleMessage(scr, this.subscriber);
        Packable p = this.subscriber.getPacket();
        CalibratorTest.assertNotNull((String)"No response sent back to subscriber", (Object)p);
        CalibratorTest.assertTrue((String)"Response Sent is not calibration result", (boolean)(p instanceof CommandResult));
        String message = ((CommandResult)p).getMessage();
        boolean calibrationGood = !message.matches(".*Error.*") && !message.matches(".*Conflict.*");
        CalibratorTest.assertTrue((String)("Response to calibration is error, but should be good: " + message), (boolean)calibrationGood);
    }

    public void testCalibrateCalibrationCommand() throws Exception {
        this.testUpdate();
        Log.report((Object)this, 4, 2, "Trying calibrate (SensorCommandRequest) ");
        int[] keys = this.makeKeys("STN01.BHZ", "STN01.BHN", this.stndb);
        CalibrationCommand cc = new CalibrationCommand(keys, "calpass", 1.6, 4.5, 10.4);
        this.calibrator.handleMessage(cc, this.subscriber);
        CalibratorTest.assertNotNull((String)"No response sent back to subscriber", (Object)this.subscriber.getPacket());
        CalibratorTest.assertTrue((String)"Response Sent is not calibration result", (boolean)(this.subscriber.getPacket() instanceof CalibrationResult));
        String message = ((CalibrationResult)this.subscriber.getPacket()).getMessage();
        boolean calibrationGood = !message.matches(".*Error.*") && !message.matches(".*Conflict.*");
        CalibratorTest.assertTrue((String)("Response to calibration is error, but should be good: " + message), (boolean)calibrationGood);
        Log.report((Object)this, 4, 2, message);
        CalibratorTest.assertNotNull((String)"No Command packet sent", (Object)this.sch.getPacket());
        CalibratorTest.assertTrue((String)"Packet Sent is not calibration command", (boolean)(this.sch.getPacket() instanceof HrdCalPacket));
        CalibratorTest.assertNotNull((String)"No response sent back to subscriber", (Object)this.subscriber.getPacket());
        CalibratorTest.assertTrue((String)"Response Sent is not calibration result", (boolean)(this.subscriber.getPacket() instanceof CalibrationResult));
    }

    public void testHandleMassCenterCommmandMessage() throws Exception {
        Log.report((Object)this, 4, 2, "Trying handleMessage (mass center)");
        this.testUpdate();
        int[] keys = this.makeKeys("STN02.BHZ", "STN02.BHN", this.stndb);
        MassCenterCommand mcc = new MassCenterCommand(keys, "calpass", 10.0f);
        this.calibrator.handleMessage(mcc, this.subscriber);
        CalibratorTest.assertNotNull((String)"No response sent back to subscriber", (Object)this.subscriber.getPacket());
        CalibratorTest.assertTrue((String)"Response Sent is not mass center result", (boolean)(this.subscriber.getPacket() instanceof MassCenterResult));
    }

    public void testConflictingHandleMessage() throws Exception {
        Log.report((Object)this, 4, 2, "Trying handleMessage (conflict)");
        ChannelList chanList = this.stndb.getChannelList();
        String instrument = "STN01";
        String[] channels = new String[]{"BHZ"};
        int instrumentID = ChannelKey.getIDOf(chanList.getKeyOf(String.valueOf(instrument) + "." + channels[0]));
        SWCalibrationCommandPacket ccp = new SWCalibrationCommandPacket((int)new Date().getTime() / 1000, instrumentID, 1, 1, 1, 0, 4.0f, 0.0f, 0.0f, 0.0f, 120.0f, "myID", 3.0f);
        SensorCommandRequest scr = new SensorCommandRequest("myID", "mhowellj", instrument, channels, ccp.toBytes());
        this.calibrator.handleMessage(scr, this.subscriber);
        this.sch.clear();
        this.subscriber.clear();
        this.calibrator.handleMessage(scr, this.subscriber);
        Packable p = this.subscriber.getPacket();
        CalibratorTest.assertNotNull((String)"No response sent back to subscriber", (Object)p);
        CalibratorTest.assertTrue((String)"Response Sent is not calibration result", (boolean)(p instanceof CommandResult));
        String message = ((CommandResult)p).getMessage();
        CalibratorTest.assertTrue((String)("Result should have had instrument conflict: " + message), (boolean)message.matches(".*Conflict.*"));
    }

    public void testPut() throws Exception {
        HrdCommandManager calibrator = new HrdCommandManager(new CalibratorConfig(), null);
        TestTracker testCalTracker = new TestTracker();
        calibrator.setCalibrationTracker(testCalTracker);
        calibrator.put(NmxPacketMaker.makeNmxPacket(1234));
        this.waitForPut();
        CalibratorTest.assertNull((String)"Packet should have had no effect", (Object)testCalTracker.getPutPacket());
        calibrator.put(NmxPacketMaker.makeLogPacket(1234, "test", 1));
        this.waitForPut();
        CalibratorTest.assertNull((String)"Packet should have had no effect", (Object)testCalTracker.getPutPacket());
        calibrator.put(NmxPacketMaker.makeLogPacket(1234, "Calibration <id>testPut</id> started.", 1));
        this.waitForPut();
        CalibratorTest.assertNotNull((String)"Calibration start should have had effect", (Object)testCalTracker.getPutPacket());
        testCalTracker.clear();
        calibrator.put(NmxPacketMaker.makeLogPacket(1234, "Calibration <id>testPut</id> finished. ", 1));
        this.waitForPut();
        CalibratorTest.assertNotNull((String)"Calibration start should have had effect", (Object)testCalTracker.getPutPacket());
    }

    private synchronized void waitForPut() {
        try {
            ((Object)((Object)this)).wait(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int[] makeKeys(String chan1, String chan2, StationDatabase _stndb) {
        ChannelList chanList = _stndb.getChannelList();
        int[] keys = new int[]{chanList.getKeyOf(chan1), chanList.getKeyOf(chan2)};
        return keys;
    }

    private class SimpleCommandHandler
    implements HrdCommandHandler {
        HrdCommandPacket hcp = null;

        public void put(HrdCommandPacket hcp) {
            this.hcp = hcp;
        }

        public HrdCommandPacket getPacket() {
            return this.hcp;
        }

        public void clear() {
            this.hcp = null;
        }
    }

    private class SimpleSubscriber
    implements MsgSubscriber {
        Packable p = null;

        public int getPort() {
            return 0;
        }

        public InetAddress getAddress() {
            return null;
        }

        public boolean send(Packable p) {
            this.p = p;
            return true;
        }

        public void flush() {
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public Packable getPacket() {
            return this.p;
        }

        public void clear() {
            this.p = null;
        }
    }

    private class TestTracker
    extends CalibrationTracker {
        private CalibrationEventMessage putMsg = null;

        private TestTracker() {
        }

        public void put(CalibrationEventMessage cem) {
            this.putMsg = cem;
        }

        public CalibrationEventMessage getPutPacket() {
            return this.putMsg;
        }

        public void clear() {
            this.putMsg = null;
        }
    }
}

