/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.net.PersistentMulticastSocket;
import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.InternetPacketWrapper;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketFactory;
import ca.nanometrics.packet.PacketWrapper;
import ca.nanometrics.util.FileLog;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.LoopRunner;
import ca.nanometrics.util.NmxDateFormat;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;

public class CheckIncoming
extends LoopRunner {
    static final int RX_BUFFER_SIZE = 512;
    private MulticastSocket ds = null;
    private PacketWrapper pw = new InternetPacketWrapper();
    private long byteCount = 0L;
    private long packetCount = 0L;
    private int reportInterval = 10;
    private long lastReportTime = 0L;
    private long lastByteCount = 0L;
    private long lastPacketCount = 0L;
    private NmxDateFormat hms = new NmxDateFormat("DDD_HH:mm:ss.SSS");

    public CheckIncoming(int port, String mcastGroup, int interval) throws IOException {
        this.reportInterval = Math.max(1, interval);
        try {
            this.ds = new PersistentMulticastSocket(port, 30000, true);
            this.ds.setSoTimeout(500);
            if (mcastGroup != null) {
                this.joinGroup(mcastGroup);
            }
        }
        catch (IOException ioe) {
            Log.report(this, 1, 5, "Cannot open datagram socket.");
            throw ioe;
        }
    }

    private void joinGroup(String mcastGroup) {
        try {
            this.ds.joinGroup(InetAddress.getByName(mcastGroup));
            Log.report(this, 2, 2, "Receiving on multicast group " + mcastGroup);
        }
        catch (Exception exc) {
            Log.report(this, 3, 3, "Cannot join multicast group " + mcastGroup);
        }
    }

    protected void open() {
        Log.report(this, 4, 2, "starting receiver on port " + this.ds.getLocalPort());
    }

    protected void close() {
        this.ds.close();
    }

    protected void tick() {
        long currentTime = System.currentTimeMillis() / 1000L;
        if (currentTime / (long)this.reportInterval != this.lastReportTime / (long)this.reportInterval) {
            this.lastReportTime = currentTime;
            long byteDelta = this.byteCount - this.lastByteCount;
            long packetDelta = this.packetCount - this.lastPacketCount;
            this.lastByteCount = this.byteCount;
            this.lastPacketCount = this.packetCount;
            Log.report(this, 5, 2, "Packets = " + this.packetCount + ", " + packetDelta + ", Bytes = " + this.byteCount + ", " + byteDelta);
        }
    }

    private void reportRxError(int errnum, DatagramPacket dp, byte[] wpkt) {
        Log.report(this, errnum, 2, "invalid packet type = " + this.pw.getDataType(wpkt) + ", len = " + dp.getLength() + ", datalen = " + this.pw.getDataLength(wpkt) + " from " + dp.getAddress().getHostAddress());
    }

    public String pktString(NmxPacket packet) {
        if (packet instanceof DataPacket) {
            DataPacket pkt = (DataPacket)packet;
            String str = String.valueOf(pkt.getInstrumentName()) + "-" + pkt.getChannel() + ":" + pkt.getSequenceNumber() + "," + pkt.getOldestSequence() + " @ " + this.hms.format(pkt.getStartTime()) + "  " + pkt.getNumSamples() + " s @ " + pkt.getSampleRate() + " sps";
            return str;
        }
        return packet.toString();
    }

    protected void handleNmxPacket(byte[] wpkt, DatagramPacket dp) {
        try {
            NmxPacket packet = NmxPacketFactory.makePacket(wpkt, this.pw.getDataOffset(), this.pw.getDataLength(wpkt));
            if (packet != null) {
                Log.report(this, 6, 1, String.valueOf(packet.isReTx() ? "R " : "n ") + this.pktString(packet));
            }
        }
        catch (Exception any) {
            Log.report(this, 7, 2, "Rx exception: " + any.getMessage());
        }
    }

    private void trybody() throws IOException {
        byte[] buffer = new byte[512];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        byte[] wpkt = dp.getData();
        Log.report(this, 0, 0, "Rx from port " + dp.getPort() + " on " + dp.getAddress().getHostAddress());
        if (this.stayAlive && dp.getAddress() != null) {
            if (this.pw.isValidPacket(wpkt, dp.getLength())) {
                ++this.packetCount;
                this.byteCount += (long)dp.getLength();
                if (this.pw.getDataType(wpkt) == 1) {
                    this.handleNmxPacket(wpkt, dp);
                } else {
                    this.reportRxError(8, dp, wpkt);
                }
            } else {
                this.reportRxError(9, dp, wpkt);
            }
        }
    }

    protected void body() {
        try {
            this.trybody();
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (Exception any) {
            Log.report(this, 10, 3, any.toString());
        }
    }

    private static void usage(String arg) {
        System.out.println("unrecognized argument: " + arg);
        System.out.println("usage:  CheckIncoming [p:port] [m:address] [r:interval] [debug]");
        System.out.println("where   port is the port on which to listen");
        System.out.println("        address is a multicast address");
        System.out.println("        interval is the reporting interval");
        System.out.println("  and   debug means to print extra debug messages");
    }

    public static void main(String[] args) throws IOException {
        int port = 32000;
        String multicast = null;
        int interval = 10;
        int verbosity = 1;
        int ix = 0;
        while (ix < args.length) {
            String arg = args[ix];
            if (arg.length() < 3) {
                CheckIncoming.usage(arg);
                System.exit(0);
            }
            String choice = arg.substring(0, 2).toLowerCase();
            String val = arg.substring(2);
            if (choice.equals("p:")) {
                port = Integer.parseInt(val);
            } else if (choice.equals("r:")) {
                interval = Integer.parseInt(val);
            } else if (choice.equals("m:")) {
                multicast = val;
            } else if (arg.equals("debug")) {
                verbosity = 0;
            } else {
                CheckIncoming.usage(args[ix]);
                System.exit(0);
            }
            ++ix;
        }
        FileLog log = new FileLog(".", "sr.log");
        Log.installLog(log);
        log.setVerbosity(verbosity);
        CheckIncoming instance = new CheckIncoming(port, multicast, interval);
        instance.start();
    }
}

