/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.io.ThreadedOutputStream;
import ca.nanometrics.msg.DefaultMessageDecoder;
import ca.nanometrics.msg.MessageDecoder;
import ca.nanometrics.msg.MsgSubscriber;
import ca.nanometrics.packet.DecompDataHandler;
import ca.nanometrics.packet.DecompDataPacket;
import ca.nanometrics.packet.InternetPacketWrapper;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.packet.Packable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class DSConnection
implements MsgSubscriber,
NmxPacketHandler,
DecompDataHandler {
    private static final int READ_SIG = 0;
    private static final int READ_TYPE = 1;
    private static final int READ_LENGTH = 2;
    private static final int READ_DATA = 3;
    private static final int READ_COMPLETE = 4;
    private static final int WRITE_TIMEOUT = 10000;
    private static final int NMX_SIGNATURE = 2059197967;
    private Socket socket;
    private boolean closed = false;
    private DataOutputStream out;
    private DataInputStream in;
    private int readState = 0;
    private int bytesRead = 0;
    private int rcvSig = 0;
    private int rcvType = 0;
    private int rcvLength = 0;
    private byte[] rcvData;
    private InternetPacketWrapper pktWrapper;
    private MessageDecoder decoder;

    public DSConnection(Socket sock) throws IOException {
        this.socket = sock;
        this.out = new DataOutputStream(new BufferedOutputStream(new ThreadedOutputStream(this.socket.getOutputStream(), 10000)));
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 1024));
        this.pktWrapper = new InternetPacketWrapper();
        this.decoder = new DefaultMessageDecoder();
        this.socket.setSoLinger(true, 1);
    }

    public void write(Packable pkt) throws IOException {
        byte[] data = this.pktWrapper.makeWrappedPacket(pkt);
        this.out.write(data);
        this.out.flush();
    }

    public boolean send(Packable pkt) {
        try {
            this.write(pkt);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Packable receive() throws IOException {
        if (this.readState == 0) {
            this.rcvSig = this.in.readInt();
            if (this.rcvSig == 2059197967) {
                this.readState = 1;
            } else {
                throw new IOException("invalid packet signature");
            }
        }
        if (this.readState == 1) {
            this.rcvType = this.in.readInt();
            this.readState = 2;
        }
        if (this.readState == 2) {
            this.rcvLength = this.in.readInt();
            this.bytesRead = 0;
            if (this.rcvLength > 0) {
                this.rcvData = new byte[this.rcvLength];
                this.readState = 3;
            } else {
                this.readState = 4;
            }
        }
        if (this.readState == 3) {
            while (this.bytesRead < this.rcvLength) {
                this.bytesRead += this.in.read(this.rcvData, this.bytesRead, this.rcvLength - this.bytesRead);
            }
            if (this.bytesRead >= this.rcvLength) {
                this.readState = 4;
            }
        }
        if (this.readState == 4) {
            byte[] msgBuffer = this.rcvData;
            this.rcvData = null;
            this.readState = 0;
            return this.decoder.decodeMessage(this.rcvType, this.rcvLength, msgBuffer);
        }
        throw new IOException("invalid state: " + this.readState);
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public InetAddress getAddress() {
        return this.socket.getInetAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public String toString() {
        String addressString = this.getAddress().getHostAddress();
        return String.valueOf(addressString) + ":" + this.getPort();
    }

    public void setTimeout(int time) throws SocketException {
        this.socket.setSoTimeout(time);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DSConnection) {
            DSConnection other = (DSConnection)obj;
            if (this.getPort() == other.getPort() && this.getAddress().equals(other.getAddress())) {
                return true;
            }
        }
        return false;
    }

    public void close() {
        if (!this.closed) {
            try {
                this.flush();
                this.socket.close();
                this.in.close();
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closed = true;
        }
    }

    public void finalize() {
        this.close();
    }

    public void put(NmxPacket packet) {
        this.send(packet);
    }

    public void put(DecompDataPacket packet) {
        this.send(packet);
    }
}

